package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 异步导出实例列表。 */
public class Dcs2AsyncExportInstancesApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2AsyncExportInstancesApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v2/instanceManageMgrServant/asyncExportInstances",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public AsyncExportInstancesResponse send(
            Credential credential, AsyncExportInstancesRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(AsyncExportInstancesResponse.class);
    }

    public static class AsyncExportInstancesRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 企业项目ID(默认值：0)，可以通过 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=77&api=7246&data=114&isNormal=1&vid=107">查询企业项目列表</a>
         * 接口，使用recordList表id字段。
         */
        @JsonProperty("projectId")
        private String projectId;

        /** 实例名称。 */
        @JsonProperty("instanceName")
        private String instanceName;

        /** 实例规格容量，单位为 GB。 */
        @JsonProperty("capacity")
        private String capacity;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /** 实例虚拟IP。 */
        @JsonProperty("vip")
        private String vip;

        /**
         * 实例状态。
         * <li>0：有效。
         * <li>1：开通中。
         * <li>2：暂停。
         * <li>3：变更中。
         * <li>4：开通失败。
         * <li>5：停止中。
         * <li>6：已停止。
         * <li>8：已退订。
         * <li>9：实例重启中。
         * <li>10：实例重启失败。
         * <li>11：网络变更中。
         * <li>-1：未知状态。
         */
        @JsonProperty("status")
        private Integer status;

        /** 引擎版本。 */
        @JsonProperty("engineVersion")
        private String engineVersion;

        /**
         * 付费类型。
         * <li>0：包年/包月。
         * <li>1: 按需。
         */
        @JsonProperty("payType")
        private Integer payType;

        /**
         * CPU架构。
         * <li>x86。
         * <li>arm。
         */
        @JsonProperty("cpuArchType")
        private String cpuArchType;

        /**
         * 标签ID列表，多个ID用英文逗号分隔，最多支持20个标签ID。<br>
         * 说明：可选参数，传值时必须为有效的非空ID逗号分隔列表。
         */
        @JsonProperty("labelIds")
        private List<String> labelIds;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public String getCapacity() {
            return this.capacity;
        }

        public void setCapacity(String capacity) {
            this.capacity = capacity;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getVip() {
            return this.vip;
        }

        public void setVip(String vip) {
            this.vip = vip;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public String getEngineVersion() {
            return this.engineVersion;
        }

        public void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public Integer getPayType() {
            return this.payType;
        }

        public void setPayType(Integer payType) {
            this.payType = payType;
        }

        public String getCpuArchType() {
            return this.cpuArchType;
        }

        public void setCpuArchType(String cpuArchType) {
            this.cpuArchType = cpuArchType;
        }

        public List<String> getLabelIds() {
            return this.labelIds;
        }

        public void setLabelIds(List<String> labelIds) {
            this.labelIds = labelIds;
        }
    }

    public static class AsyncExportInstancesResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 返回数据对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private AsyncExportInstancesReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public AsyncExportInstancesReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(AsyncExportInstancesReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class AsyncExportInstancesReturnObjResponse {
        /** 任务ID */
        @JsonProperty("taskId")
        private String taskId;

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }
    }
}
