package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 推荐索引字段列表 */
public class CtltsViewIndicesApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsViewIndicesApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v1/index/viewIndices", "text/plain");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ViewIndicesResponse send(Credential credential, ViewIndicesRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.projectCode != null) {
            ctReq.addParam("projectCode", request.projectCode);
            request.projectCode = null;
        }
        if (request.unitCode != null) {
            ctReq.addParam("unitCode", request.unitCode);
            request.unitCode = null;
        }
        ctReq.writeString("", template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ViewIndicesResponse.class);
    }

    public static class ViewIndicesRequest {
        /** 资源池编码，请参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 日志项目ID。日志项目列表接口会返回日志项目ID */
        @JsonProperty("projectCode")
        private String projectCode;

        /** 日志单元ID。日志单元列表接口会返回日志单元ID */
        @JsonProperty("unitCode")
        private String unitCode;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProjectCode() {
            return this.projectCode;
        }

        public void setProjectCode(String projectCode) {
            this.projectCode = projectCode;
        }

        public String getUnitCode() {
            return this.unitCode;
        }

        public void setUnitCode(String unitCode) {
            this.unitCode = unitCode;
        }
    }

    public static class ViewIndicesResponse {
        /** 响应状态码。0：代表正常；-1：代表严重错误；-2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求响应数据体 */
        @JsonProperty("returnObj")
        private List<ViewIndicesReturnObjResponse> returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public List<ViewIndicesReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<ViewIndicesReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ViewIndicesReturnObjResponse {
        /** 字段名 */
        @JsonProperty("fieldName")
        private String fieldName;

        /** 字段类型：text，double，long */
        @JsonProperty("dataType")
        private String dataType;

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getDataType() {
            return this.dataType;
        }

        public void setDataType(String dataType) {
            this.dataType = dataType;
        }
    }
}
