package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 该接口用于修改指定日志单元下的日志存储时长和描述 */
public class CtltsUpdateUnitApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsUpdateUnitApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/v1/unit/update", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public UpdateUnitResponse send(Credential credential, UpdateUnitRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(UpdateUnitResponse.class);
    }

    public static class UpdateUnitRequest {
        /** 资源池编码，可参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 日志项目ID。可在云日志控制台 日志管理->日志项目列表->鼠标悬浮查看日志项目ID */
        @JsonProperty("projectCode")
        private String projectCode;

        /** 日志单元ID。可在云日志控制台 日志管理 -> 日志项目列表 -> 展开单元列表 -> 鼠标悬浮查看日志单元ID */
        @JsonProperty("unitCode")
        private String unitCode;

        /** 日志存储时长（单位：天），最小1，最大365。 */
        @JsonProperty("ttlDays")
        private Integer ttlDays;

        /** 日志单元描述 */
        @JsonProperty("description")
        private String description;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProjectCode() {
            return this.projectCode;
        }

        public void setProjectCode(String projectCode) {
            this.projectCode = projectCode;
        }

        public String getUnitCode() {
            return this.unitCode;
        }

        public void setUnitCode(String unitCode) {
            this.unitCode = unitCode;
        }

        public Integer getTtlDays() {
            return this.ttlDays;
        }

        public void setTtlDays(Integer ttlDays) {
            this.ttlDays = ttlDays;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }

    public static class UpdateUnitResponse {
        /** 响应状态码。0：代表正常； -1：代表严重错误； -2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求响应数据体 */
        @JsonProperty("returnObj")
        private UpdateUnitReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public UpdateUnitReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(UpdateUnitReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class UpdateUnitReturnObjResponse {}
}
