package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 更新加工任务 */
public class CtltsUpdateProcessTaskApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsUpdateProcessTaskApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v1/dataProcess/updateProcessTask",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public UpdateProcessTaskResponse send(Credential credential, UpdateProcessTaskRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(UpdateProcessTaskResponse.class);
    }

    public static class UpdateProcessTaskRequest {
        /** 资源池编码，可参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 任务编码, 可通过列出指定Project下的加工任务接口获取 */
        @JsonProperty("taskCode")
        private String taskCode;

        /** 任务名称：用户自定义，支持最大64个字符, 不填的话默认使用旧的名称 */
        @JsonProperty("taskName")
        private String taskName;

        /** 目标列表, 目前仅支持加工到一个目标，填多个时，以第一个为准 */
        @JsonProperty("aimList")
        private List<UpdateProcessTaskAimListRequest> aimList;

        /** 加工脚本, 默认不加工 */
        @JsonProperty("processScript")
        private String processScript;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getTaskCode() {
            return this.taskCode;
        }

        public void setTaskCode(String taskCode) {
            this.taskCode = taskCode;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public void setTaskName(String taskName) {
            this.taskName = taskName;
        }

        public List<UpdateProcessTaskAimListRequest> getAimList() {
            return this.aimList;
        }

        public void setAimList(List<UpdateProcessTaskAimListRequest> aimList) {
            this.aimList = aimList;
        }

        public String getProcessScript() {
            return this.processScript;
        }

        public void setProcessScript(String processScript) {
            this.processScript = processScript;
        }
    }

    public static class UpdateProcessTaskAimListRequest {
        /** 目标名称：用户自定义，支持最大64个字符 */
        @JsonProperty("aimName")
        private String aimName;

        /** 目标日志项目ID */
        @JsonProperty("aimProjectCode")
        private String aimProjectCode;

        /** 目标日志单元ID */
        @JsonProperty("aimUnitCode")
        private String aimUnitCode;

        public String getAimName() {
            return this.aimName;
        }

        public void setAimName(String aimName) {
            this.aimName = aimName;
        }

        public String getAimProjectCode() {
            return this.aimProjectCode;
        }

        public void setAimProjectCode(String aimProjectCode) {
            this.aimProjectCode = aimProjectCode;
        }

        public String getAimUnitCode() {
            return this.aimUnitCode;
        }

        public void setAimUnitCode(String aimUnitCode) {
            this.aimUnitCode = aimUnitCode;
        }
    }

    public static class UpdateProcessTaskResponse {
        /** 响应状态码。0：代表正常； -1：代表严重错误； -2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求id */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求接口返回的数据体 */
        @JsonProperty("returnObj")
        private UpdateProcessTaskReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public UpdateProcessTaskReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(UpdateProcessTaskReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class UpdateProcessTaskReturnObjResponse {
        /** 任务编码 */
        @JsonProperty("taskCode")
        private String taskCode;

        public String getTaskCode() {
            return this.taskCode;
        }

        public void setTaskCode(String taskCode) {
            this.taskCode = taskCode;
        }
    }
}
