package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 编辑ZOS对象存储导入任务 */
public class CtltsUpdateOssImportTaskApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsUpdateOssImportTaskApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v1/import/updateOssImportTask",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public UpdateOssImportTaskResponse send(
            Credential credential, UpdateOssImportTaskRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(UpdateOssImportTaskResponse.class);
    }

    public static class UpdateOssImportTaskRequest {
        /** 资源池编码，可参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 任务编码，创建对象存储导入任务或Kafka导入任务时返回，或者根据导入任务列表接口获取 */
        @JsonProperty("code")
        private String code;

        /** 日志单元ID */
        @JsonProperty("unitCode")
        private String unitCode;

        /** 日志项目ID */
        @JsonProperty("projectCode")
        private String projectCode;

        /** 文件编码, 支持传入UTF8和GBK */
        @JsonProperty("encode")
        private String encode;

        /** 数据格式, 支持传入TEXT：单行全文；MULTI_TEXT：多行全文；JSON：JSON模式 */
        @JsonProperty("format")
        private String format;

        /** 对象存储bucket名称 */
        @JsonProperty("bucket")
        private String bucket;

        /** 可选值，none：非压缩；auto：自动检测；snappy：snappy压缩, gzip：gzip压缩； zstd：zstd压缩；lz4：lz4压缩 */
        @JsonProperty("compressionCodec")
        private String compressionCodec;

        /** 文件路径前缀过滤, 非必传 */
        @JsonProperty("pathPrefix")
        private String pathPrefix;

        /** 文件路径正则过滤,例如：^(s+)$ */
        @JsonProperty("pathPattern")
        private String pathPattern;

        /** 文件修改时间过滤开始时间, 单位:毫秒 */
        @JsonProperty("startTime")
        private Long startTime;

        /** 文件修改时间截止时间, 单位:毫秒 */
        @JsonProperty("endTime")
        private Long endTime;

        /** 用户自定义cron表达式, 自定义cron时传值 */
        @JsonProperty("cron")
        private String cron;

        /** 用户自定义时间戳, 非必传 */
        @JsonProperty("customTimeInfoVo")
        private UpdateOssImportTaskCustomTimeInfoVoRequest customTimeInfoVo;

        /** 正则切割时传参 */
        @JsonProperty("regex")
        private UpdateOssImportTaskRegexRequest regex;

        /** 定时任务检查新文件周期, 永不检查则不传参 */
        @JsonProperty("CheckCycle")
        private UpdateOssImportTaskCheckCycleRequest checkCycle;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getUnitCode() {
            return this.unitCode;
        }

        public void setUnitCode(String unitCode) {
            this.unitCode = unitCode;
        }

        public String getProjectCode() {
            return this.projectCode;
        }

        public void setProjectCode(String projectCode) {
            this.projectCode = projectCode;
        }

        public String getEncode() {
            return this.encode;
        }

        public void setEncode(String encode) {
            this.encode = encode;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public String getBucket() {
            return this.bucket;
        }

        public void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public String getCompressionCodec() {
            return this.compressionCodec;
        }

        public void setCompressionCodec(String compressionCodec) {
            this.compressionCodec = compressionCodec;
        }

        public String getPathPrefix() {
            return this.pathPrefix;
        }

        public void setPathPrefix(String pathPrefix) {
            this.pathPrefix = pathPrefix;
        }

        public String getPathPattern() {
            return this.pathPattern;
        }

        public void setPathPattern(String pathPattern) {
            this.pathPattern = pathPattern;
        }

        public Long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public Long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        public String getCron() {
            return this.cron;
        }

        public void setCron(String cron) {
            this.cron = cron;
        }

        public UpdateOssImportTaskCustomTimeInfoVoRequest getCustomTimeInfoVo() {
            return this.customTimeInfoVo;
        }

        public void setCustomTimeInfoVo(
                UpdateOssImportTaskCustomTimeInfoVoRequest customTimeInfoVo) {
            this.customTimeInfoVo = customTimeInfoVo;
        }

        public UpdateOssImportTaskRegexRequest getRegex() {
            return this.regex;
        }

        public void setRegex(UpdateOssImportTaskRegexRequest regex) {
            this.regex = regex;
        }

        public UpdateOssImportTaskCheckCycleRequest getCheckCycle() {
            return this.checkCycle;
        }

        public void setCheckCycle(UpdateOssImportTaskCheckCycleRequest checkCycle) {
            this.checkCycle = checkCycle;
        }
    }

    public static class UpdateOssImportTaskCustomTimeInfoVoRequest {
        /** 提取字段名 */
        @JsonProperty("key")
        private String key;

        /** 时间值 */
        @JsonProperty("value")
        private String value;

        /** 提取时间格式 */
        @JsonProperty("timeFormat")
        private String timeFormat;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getTimeFormat() {
            return this.timeFormat;
        }

        public void setTimeFormat(String timeFormat) {
            this.timeFormat = timeFormat;
        }
    }

    public static class UpdateOssImportTaskRegexRequest {
        /** 提取正则, 单行正则或多行正则提取模式下必填，例如：(\d+-\d+-\d+\s\S+)\s+\[([^]]+)]\s+(\w+)\s+(\S+)\s+(.*) */
        @JsonProperty("regexStr")
        private String regexStr;

        /** 分割所得类型字段，输入顺序会被使用，正则/多行正则时会被匹配使用 */
        @JsonProperty("logContent")
        private List<UpdateOssImportTaskRegexLogContentRequest> logContent;

        public String getRegexStr() {
            return this.regexStr;
        }

        public void setRegexStr(String regexStr) {
            this.regexStr = regexStr;
        }

        public List<UpdateOssImportTaskRegexLogContentRequest> getLogContent() {
            return this.logContent;
        }

        public void setLogContent(List<UpdateOssImportTaskRegexLogContentRequest> logContent) {
            this.logContent = logContent;
        }
    }

    public static class UpdateOssImportTaskCheckCycleRequest {
        /** 定时任务周期单位, minute：分钟；day：天；hour：小时；与时间间隔一起使用 */
        @JsonProperty("unit")
        private String unit;

        /** 时间间隔, 与任务周期单位一起使用 */
        @JsonProperty("interval")
        private Long interval;

        public String getUnit() {
            return this.unit;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        public Long getInterval() {
            return this.interval;
        }

        public void setInterval(Long interval) {
            this.interval = interval;
        }
    }

    public static class UpdateOssImportTaskRegexLogContentRequest {
        /** 提取字段 */
        @JsonProperty("key")
        private String key;

        /** 数据类型。text：字符串；double：数字 */
        @JsonProperty("type")
        private String type;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    public static class UpdateOssImportTaskResponse {
        /** 响应状态码。0：代表正常； -1：代表严重错误； -2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 调用错误时返回的错误编码 */
        @JsonProperty("error")
        private String error;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 消息内容 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private UpdateOssImportTaskReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public UpdateOssImportTaskReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(UpdateOssImportTaskReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class UpdateOssImportTaskReturnObjResponse {}
}
