package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 编辑分布式消费服务-Kafka导入任务 */
public class CtltsUpdateKafkaImportTaskApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsUpdateKafkaImportTaskApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v1/import/updateKafkaImportTask",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public UpdateKafkaImportTaskResponse send(
            Credential credential, UpdateKafkaImportTaskRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(UpdateKafkaImportTaskResponse.class);
    }

    public static class UpdateKafkaImportTaskRequest {
        /** 资源池编码，可参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** Kafka导入任务编码，创建Kafka导入任务接口会返回任务编码或根据导入任务列表接口查询 */
        @JsonProperty("code")
        private String code;

        /** 日志单元ID */
        @JsonProperty("unitCode")
        private String unitCode;

        /** 日志项目ID */
        @JsonProperty("projectCode")
        private String projectCode;

        /** kafka导入所消费的topic列表 */
        @JsonProperty("topics")
        private List<String> topics;

        /** 消费组拉取消息起始位置, newest：从topic消息最早位置开始消费；oldest：从topic消息最新位置开始消费 */
        @JsonProperty("offset")
        private String offset;

        /** 消费者组 */
        @JsonProperty("consumerGroup")
        private String consumerGroup;

        /** 文件编码, 支持传入UTF8和GBK */
        @JsonProperty("encode")
        private String encode;

        /** 数据格式, TEXT：单行全文；MULTI_TEXT：多行全文；JSON：JSON模式 */
        @JsonProperty("format")
        private String format;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getUnitCode() {
            return this.unitCode;
        }

        public void setUnitCode(String unitCode) {
            this.unitCode = unitCode;
        }

        public String getProjectCode() {
            return this.projectCode;
        }

        public void setProjectCode(String projectCode) {
            this.projectCode = projectCode;
        }

        public List<String> getTopics() {
            return this.topics;
        }

        public void setTopics(List<String> topics) {
            this.topics = topics;
        }

        public String getOffset() {
            return this.offset;
        }

        public void setOffset(String offset) {
            this.offset = offset;
        }

        public String getConsumerGroup() {
            return this.consumerGroup;
        }

        public void setConsumerGroup(String consumerGroup) {
            this.consumerGroup = consumerGroup;
        }

        public String getEncode() {
            return this.encode;
        }

        public void setEncode(String encode) {
            this.encode = encode;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }
    }

    public static class UpdateKafkaImportTaskResponse {
        /** 响应状态码。0：代表正常； -1：代表严重错误； -2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 调用错误时返回的错误编码 */
        @JsonProperty("error")
        private String error;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 消息内容 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private UpdateKafkaImportTaskReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public UpdateKafkaImportTaskReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(UpdateKafkaImportTaskReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class UpdateKafkaImportTaskReturnObjResponse {}
}
