package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 更新采集规则 */
public class CtltsUpdateCollectRuleApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsUpdateCollectRuleApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/v1/collectorRule/update", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public UpdateCollectRuleResponse send(Credential credential, UpdateCollectRuleRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(UpdateCollectRuleResponse.class);
    }

    public static class UpdateCollectRuleRequest {
        /** 资源池编码，请参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 日志单元ID，可通过采集规则详情接口获取 */
        @JsonProperty("unitCode")
        private String unitCode;

        /** 采集规则ID，可通过采集规则详情接口获取 */
        @JsonProperty("ruleCode")
        private String ruleCode;

        /** 待采集的日志文件路径列表（目前仅限1个路径）。路径中支持使用*和**通配符，其中**通配符仅能出现一次且仅限用于文件名前 */
        @JsonProperty("logPaths")
        private List<String> logPaths;

        /** 提取模式，不同模式对应其他参数不同。1：单行正则；2：分隔符；3：多行正则；4：单行全文；5：json；6：多行全文；7：组合解析；8：nginx模板解析 */
        @JsonProperty("cuttingMode")
        private String cuttingMode;

        /**
         * 采集类型。1：云主机-文本日志；2：云容器引擎-标准输出；3：云容器引擎-文本日志；4：syslog-协议；5：物理机-文本日志；6：windows事件日志；7：对象存储文件；8：Kafka数据导入；9：Systemd
         * Journal日志；10：审计日志；11：k8s节点文件日志
         */
        @JsonProperty("extractMode")
        private Byte extractMode;

        /** 首行正则，例如：\d+-\d+-\d+\s\d+:\d+:\d+\.\d+\s.* */
        @JsonProperty("firstLinePattern")
        private String firstLinePattern;

        /** 自定义时间戳提取格式 */
        @JsonProperty("customTime")
        private UpdateCollectRuleCustomTimeRequest customTime;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getUnitCode() {
            return this.unitCode;
        }

        public void setUnitCode(String unitCode) {
            this.unitCode = unitCode;
        }

        public String getRuleCode() {
            return this.ruleCode;
        }

        public void setRuleCode(String ruleCode) {
            this.ruleCode = ruleCode;
        }

        public List<String> getLogPaths() {
            return this.logPaths;
        }

        public void setLogPaths(List<String> logPaths) {
            this.logPaths = logPaths;
        }

        public String getCuttingMode() {
            return this.cuttingMode;
        }

        public void setCuttingMode(String cuttingMode) {
            this.cuttingMode = cuttingMode;
        }

        public Byte getExtractMode() {
            return this.extractMode;
        }

        public void setExtractMode(Byte extractMode) {
            this.extractMode = extractMode;
        }

        public String getFirstLinePattern() {
            return this.firstLinePattern;
        }

        public void setFirstLinePattern(String firstLinePattern) {
            this.firstLinePattern = firstLinePattern;
        }

        public UpdateCollectRuleCustomTimeRequest getCustomTime() {
            return this.customTime;
        }

        public void setCustomTime(UpdateCollectRuleCustomTimeRequest customTime) {
            this.customTime = customTime;
        }
    }

    public static class UpdateCollectRuleCustomTimeRequest {
        /** 提取字段名 */
        @JsonProperty("key")
        private String key;

        /** 提取时间格式，如yyyy-MM-dd HH:MM:SS */
        @JsonProperty("timeFormat")
        private String timeFormat;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getTimeFormat() {
            return this.timeFormat;
        }

        public void setTimeFormat(String timeFormat) {
            this.timeFormat = timeFormat;
        }
    }

    public static class UpdateCollectRuleResponse {
        /** 响应状态码。0：代表正常； -1：代表严重错误； -2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求响应数据体 */
        @JsonProperty("returnObj")
        private UpdateCollectRuleReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public UpdateCollectRuleReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(UpdateCollectRuleReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class UpdateCollectRuleReturnObjResponse {}
}
