package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 更新触发条件 */
public class CtltsUpdateAlertRuleTriggerCondsApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsUpdateAlertRuleTriggerCondsApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v1/alert/rule/updateAlertRuleTriggerConds",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public UpdateAlertRuleTriggerCondsResponse send(
            Credential credential, UpdateAlertRuleTriggerCondsRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(UpdateAlertRuleTriggerCondsResponse.class);
    }

    public static class UpdateAlertRuleTriggerCondsRequest {
        /** 资源池编码，请参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 告警规则编码。创建接口和列表接口会返回日志告警规则编码 */
        @JsonProperty("ruleCode")
        private String ruleCode;

        /** 触发条件 */
        @JsonProperty("triggerConds")
        private List<UpdateAlertRuleTriggerCondsTriggerCondsRequest> triggerConds;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getRuleCode() {
            return this.ruleCode;
        }

        public void setRuleCode(String ruleCode) {
            this.ruleCode = ruleCode;
        }

        public List<UpdateAlertRuleTriggerCondsTriggerCondsRequest> getTriggerConds() {
            return this.triggerConds;
        }

        public void setTriggerConds(
                List<UpdateAlertRuleTriggerCondsTriggerCondsRequest> triggerConds) {
            this.triggerConds = triggerConds;
        }
    }

    public static class UpdateAlertRuleTriggerCondsTriggerCondsRequest {
        /** 触发模式，1：有数据；2：有特定条数据；3：有数据匹配；4：有特定条数据匹配 */
        @JsonProperty("triggerModel")
        private Byte triggerModel;

        /** 比较值：>，<，>=，<=，= （当 triggerModel 为 2 或 4 时，必填） */
        @JsonProperty("compare")
        private String compare;

        /** 告警阈值（当 triggerModel 为 2 或 4 时，必填） */
        @JsonProperty("value")
        private Long value;

        /** 条件表达式（当 triggerModel 为 3 或 4 时，必填） */
        @JsonProperty("evalCondition")
        private String evalCondition;

        /** 告警等级取值范围，1：一般；2：次要；3：重要；4：紧急 */
        @JsonProperty("alertLevel")
        private Byte alertLevel;

        public Byte getTriggerModel() {
            return this.triggerModel;
        }

        public void setTriggerModel(Byte triggerModel) {
            this.triggerModel = triggerModel;
        }

        public String getCompare() {
            return this.compare;
        }

        public void setCompare(String compare) {
            this.compare = compare;
        }

        public Long getValue() {
            return this.value;
        }

        public void setValue(Long value) {
            this.value = value;
        }

        public String getEvalCondition() {
            return this.evalCondition;
        }

        public void setEvalCondition(String evalCondition) {
            this.evalCondition = evalCondition;
        }

        public Byte getAlertLevel() {
            return this.alertLevel;
        }

        public void setAlertLevel(Byte alertLevel) {
            this.alertLevel = alertLevel;
        }
    }

    public static class UpdateAlertRuleTriggerCondsResponse {
        /** 响应状态码。0：代表正常；-1：代表严重错误；-2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求响应数据体 */
        @JsonProperty("returnObj")
        private String returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(String returnObj) {
            this.returnObj = returnObj;
        }
    }
}
