package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 更新检索条件 */
public class CtltsUpdateAlertRuleLogSearchCondsApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsUpdateAlertRuleLogSearchCondsApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v1/alert/rule/updateAlertRuleLogSearchConds",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public UpdateAlertRuleLogSearchCondsResponse send(
            Credential credential, UpdateAlertRuleLogSearchCondsRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(UpdateAlertRuleLogSearchCondsResponse.class);
    }

    public static class UpdateAlertRuleLogSearchCondsRequest {
        /** 资源池编码，请参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 告警规则编码。创建接口和列表接口会返回日志告警规则编码 */
        @JsonProperty("ruleCode")
        private String ruleCode;

        /** 检索条件 */
        @JsonProperty("logSearch")
        private UpdateAlertRuleLogSearchCondsLogSearchRequest logSearch;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getRuleCode() {
            return this.ruleCode;
        }

        public void setRuleCode(String ruleCode) {
            this.ruleCode = ruleCode;
        }

        public UpdateAlertRuleLogSearchCondsLogSearchRequest getLogSearch() {
            return this.logSearch;
        }

        public void setLogSearch(UpdateAlertRuleLogSearchCondsLogSearchRequest logSearch) {
            this.logSearch = logSearch;
        }
    }

    public static class UpdateAlertRuleLogSearchCondsLogSearchRequest {
        /** 日志项目ID。日志项目列表接口会返回日志项目ID */
        @JsonProperty("projectCode")
        private String projectCode;

        /** 日志单元ID。日志单元列表接口会返回日志单元ID */
        @JsonProperty("unitCode")
        private String unitCode;

        /** 检索时间范围，填写整数值，最长不超过1天 */
        @JsonProperty("searchDuration")
        private Integer searchDuration;

        /** 检索时间单位，1：分钟；2：小时；3：天 */
        @JsonProperty("searchDurationUnit")
        private Byte searchDurationUnit;

        /** 检索分析SQL */
        @JsonProperty("querySql")
        private String querySql;

        public String getProjectCode() {
            return this.projectCode;
        }

        public void setProjectCode(String projectCode) {
            this.projectCode = projectCode;
        }

        public String getUnitCode() {
            return this.unitCode;
        }

        public void setUnitCode(String unitCode) {
            this.unitCode = unitCode;
        }

        public Integer getSearchDuration() {
            return this.searchDuration;
        }

        public void setSearchDuration(Integer searchDuration) {
            this.searchDuration = searchDuration;
        }

        public Byte getSearchDurationUnit() {
            return this.searchDurationUnit;
        }

        public void setSearchDurationUnit(Byte searchDurationUnit) {
            this.searchDurationUnit = searchDurationUnit;
        }

        public String getQuerySql() {
            return this.querySql;
        }

        public void setQuerySql(String querySql) {
            this.querySql = querySql;
        }
    }

    public static class UpdateAlertRuleLogSearchCondsResponse {
        /** 响应状态码。0：代表正常；-1：代表严重错误；-2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求响应数据体 */
        @JsonProperty("returnObj")
        private UpdateAlertRuleLogSearchCondsReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public UpdateAlertRuleLogSearchCondsReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(UpdateAlertRuleLogSearchCondsReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class UpdateAlertRuleLogSearchCondsReturnObjResponse {}
}
