package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 更新告警规则 */
public class CtltsUpdateAlertRuleApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsUpdateAlertRuleApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/v1/alert/rule/update", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public UpdateAlertRuleResponse send(Credential credential, UpdateAlertRuleRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(UpdateAlertRuleResponse.class);
    }

    public static class UpdateAlertRuleRequest {
        /** 资源池编码，请参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 告警规则编码。创建接口和列表接口会返回日志告警规则编码 */
        @JsonProperty("ruleCode")
        private String ruleCode;

        /** 告警规则名称，长度在1-50个字符范围内 */
        @JsonProperty("ruleName")
        private String ruleName;

        /** 检查频率，1：固定频率；2：固定时间 */
        @JsonProperty("queryMode")
        private Byte queryMode;

        /** 固定频率间隔 （queryMode=1 的时候，必填） */
        @JsonProperty("queryDuration")
        private Integer queryDuration;

        /** 固定频率间隔单位，1：分钟；2：小时；3：天（queryMode=1 的时候，必填） */
        @JsonProperty("queryDurationUnit")
        private Byte queryDurationUnit;

        /** 固定时间，格式：HH:MM（queryMode=2 的时候，必填） */
        @JsonProperty("queryTime")
        private String queryTime;

        /** 检索条件 */
        @JsonProperty("logSearch")
        private UpdateAlertRuleLogSearchRequest logSearch;

        /** 触发条件 */
        @JsonProperty("triggerConds")
        private List<UpdateAlertRuleTriggerCondsRequest> triggerConds;

        /** 通知策略ID。应用性能监控APM产品，通知策略列表接口会返回通知策略ID，不传递则更新为不指定通知策略 */
        @JsonProperty("notifyStrategyId")
        private Long notifyStrategyId;

        /** 告警通知模板 */
        @JsonProperty("alertMessageTemplate")
        private String alertMessageTemplate;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getRuleCode() {
            return this.ruleCode;
        }

        public void setRuleCode(String ruleCode) {
            this.ruleCode = ruleCode;
        }

        public String getRuleName() {
            return this.ruleName;
        }

        public void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public Byte getQueryMode() {
            return this.queryMode;
        }

        public void setQueryMode(Byte queryMode) {
            this.queryMode = queryMode;
        }

        public Integer getQueryDuration() {
            return this.queryDuration;
        }

        public void setQueryDuration(Integer queryDuration) {
            this.queryDuration = queryDuration;
        }

        public Byte getQueryDurationUnit() {
            return this.queryDurationUnit;
        }

        public void setQueryDurationUnit(Byte queryDurationUnit) {
            this.queryDurationUnit = queryDurationUnit;
        }

        public String getQueryTime() {
            return this.queryTime;
        }

        public void setQueryTime(String queryTime) {
            this.queryTime = queryTime;
        }

        public UpdateAlertRuleLogSearchRequest getLogSearch() {
            return this.logSearch;
        }

        public void setLogSearch(UpdateAlertRuleLogSearchRequest logSearch) {
            this.logSearch = logSearch;
        }

        public List<UpdateAlertRuleTriggerCondsRequest> getTriggerConds() {
            return this.triggerConds;
        }

        public void setTriggerConds(List<UpdateAlertRuleTriggerCondsRequest> triggerConds) {
            this.triggerConds = triggerConds;
        }

        public Long getNotifyStrategyId() {
            return this.notifyStrategyId;
        }

        public void setNotifyStrategyId(Long notifyStrategyId) {
            this.notifyStrategyId = notifyStrategyId;
        }

        public String getAlertMessageTemplate() {
            return this.alertMessageTemplate;
        }

        public void setAlertMessageTemplate(String alertMessageTemplate) {
            this.alertMessageTemplate = alertMessageTemplate;
        }
    }

    public static class UpdateAlertRuleLogSearchRequest {
        /** 日志项目ID。日志项目列表接口会返回日志项目ID */
        @JsonProperty("projectCode")
        private String projectCode;

        /** 日志单元ID。日志单元列表接口会返回日志单元ID */
        @JsonProperty("unitCode")
        private String unitCode;

        /** 检索时间范围，填写整数值，最长不超过1天 */
        @JsonProperty("searchDuration")
        private Integer searchDuration;

        /** 检索时间单位，1：分钟；2：小时；3：天 */
        @JsonProperty("searchDurationUnit")
        private Byte searchDurationUnit;

        /** 检索分析SQL */
        @JsonProperty("querySql")
        private String querySql;

        public String getProjectCode() {
            return this.projectCode;
        }

        public void setProjectCode(String projectCode) {
            this.projectCode = projectCode;
        }

        public String getUnitCode() {
            return this.unitCode;
        }

        public void setUnitCode(String unitCode) {
            this.unitCode = unitCode;
        }

        public Integer getSearchDuration() {
            return this.searchDuration;
        }

        public void setSearchDuration(Integer searchDuration) {
            this.searchDuration = searchDuration;
        }

        public Byte getSearchDurationUnit() {
            return this.searchDurationUnit;
        }

        public void setSearchDurationUnit(Byte searchDurationUnit) {
            this.searchDurationUnit = searchDurationUnit;
        }

        public String getQuerySql() {
            return this.querySql;
        }

        public void setQuerySql(String querySql) {
            this.querySql = querySql;
        }
    }

    public static class UpdateAlertRuleTriggerCondsRequest {
        /** 触发模式，1：有数据；2：有特定条数据；3：有数据匹配；4：有特定条数据匹配 */
        @JsonProperty("triggerModel")
        private Byte triggerModel;

        /** 比较值：>，<，>=，<=，= （当 triggerModel 为 2 或 4 时，必填） */
        @JsonProperty("compare")
        private String compare;

        /** 告警阈值（当 triggerModel 为 2 或 4 时，必填） */
        @JsonProperty("value")
        private Long value;

        /** 条件表达式（当 triggerModel 为 3 或 4 时，必填） */
        @JsonProperty("evalCondition")
        private String evalCondition;

        /** 告警等级取值范围，1：一般；2：次要；3：重要；4：紧急 */
        @JsonProperty("alertLevel")
        private Byte alertLevel;

        public Byte getTriggerModel() {
            return this.triggerModel;
        }

        public void setTriggerModel(Byte triggerModel) {
            this.triggerModel = triggerModel;
        }

        public String getCompare() {
            return this.compare;
        }

        public void setCompare(String compare) {
            this.compare = compare;
        }

        public Long getValue() {
            return this.value;
        }

        public void setValue(Long value) {
            this.value = value;
        }

        public String getEvalCondition() {
            return this.evalCondition;
        }

        public void setEvalCondition(String evalCondition) {
            this.evalCondition = evalCondition;
        }

        public Byte getAlertLevel() {
            return this.alertLevel;
        }

        public void setAlertLevel(Byte alertLevel) {
            this.alertLevel = alertLevel;
        }
    }

    public static class UpdateAlertRuleResponse {
        /** 响应状态码。0：代表正常；-1：代表严重错误；-2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求响应数据体 */
        @JsonProperty("returnObj")
        private UpdateAlertRuleReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public UpdateAlertRuleReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(UpdateAlertRuleReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class UpdateAlertRuleReturnObjResponse {}
}
