package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 为指定的资源解绑标签 */
public class CtltsUnlabelForResouceApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsUnlabelForResouceApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/v1/tags/untag", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public UnlabelForResouceResponse send(Credential credential, UnlabelForResouceRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(UnlabelForResouceResponse.class);
    }

    public static class UnlabelForResouceRequest {
        /** 资源池编码，请参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 资源类型，枚举值：project；unit */
        @JsonProperty("sourceType")
        private String sourceType;

        /** 资源编码。例如日志项目ID */
        @JsonProperty("baseResourceId")
        private String baseResourceId;

        /** 标签ID列表 */
        @JsonProperty("tagIdList")
        private List<String> tagIdList;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getSourceType() {
            return this.sourceType;
        }

        public void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public String getBaseResourceId() {
            return this.baseResourceId;
        }

        public void setBaseResourceId(String baseResourceId) {
            this.baseResourceId = baseResourceId;
        }

        public List<String> getTagIdList() {
            return this.tagIdList;
        }

        public void setTagIdList(List<String> tagIdList) {
            this.tagIdList = tagIdList;
        }
    }

    public static class UnlabelForResouceResponse {
        /** 响应状态码。0：代表正常；-1：代表严重错误；-2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求响应数据体 */
        @JsonProperty("returnObj")
        private UnlabelForResouceReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public UnlabelForResouceReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(UnlabelForResouceReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class UnlabelForResouceReturnObjResponse {}
}
