package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 从目标主机组中移除关联的日志采集规则 */
public class CtltsRemoveFromHostGroupsApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsRemoveFromHostGroupsApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v1/collectorRule/hostGroup/remove",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public RemoveFromHostGroupsResponse send(
            Credential credential, RemoveFromHostGroupsRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(RemoveFromHostGroupsResponse.class);
    }

    public static class RemoveFromHostGroupsRequest {
        /** 资源池编码，请参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 采集规则编码，可从采集规则列表获取 */
        @JsonProperty("ruleCode")
        private String ruleCode;

        /** 主机组编码，可从主机组列表获取 */
        @JsonProperty("hostGroupCodeList")
        private List<String> hostGroupCodeList;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getRuleCode() {
            return this.ruleCode;
        }

        public void setRuleCode(String ruleCode) {
            this.ruleCode = ruleCode;
        }

        public List<String> getHostGroupCodeList() {
            return this.hostGroupCodeList;
        }

        public void setHostGroupCodeList(List<String> hostGroupCodeList) {
            this.hostGroupCodeList = hostGroupCodeList;
        }
    }

    public static class RemoveFromHostGroupsResponse {
        /** 响应状态码。0：代表正常；-1：代表严重错误；-2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求响应数据体 */
        @JsonProperty("returnObj")
        private RemoveFromHostGroupsReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public RemoveFromHostGroupsReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(RemoveFromHostGroupsReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class RemoveFromHostGroupsReturnObjResponse {}
}
