package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 查询采集规则所属日志单元 */
public class CtltsQueryUnitInfoByRuleCodeApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsQueryUnitInfoByRuleCodeApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v1/collectorRule/queryUnitInfoByRuleCode",
                        "text/plain");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryUnitInfoByRuleCodeResponse send(
            Credential credential, QueryUnitInfoByRuleCodeRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.collectRuleCode != null) {
            ctReq.addParam("collectRuleCode", request.collectRuleCode);
            request.collectRuleCode = null;
        }
        ctReq.writeString("", template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryUnitInfoByRuleCodeResponse.class);
    }

    public static class QueryUnitInfoByRuleCodeRequest {
        /** 资源池编码，请参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 采集规则编码，可从采集规则列表获取 */
        @JsonProperty("collectRuleCode")
        private String collectRuleCode;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getCollectRuleCode() {
            return this.collectRuleCode;
        }

        public void setCollectRuleCode(String collectRuleCode) {
            this.collectRuleCode = collectRuleCode;
        }
    }

    public static class QueryUnitInfoByRuleCodeResponse {
        /** 响应状态码。0：代表正常；-1：代表严重错误；-2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 日志单元详情 */
        @JsonProperty("returnObj")
        private QueryUnitInfoByRuleCodeReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public QueryUnitInfoByRuleCodeReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryUnitInfoByRuleCodeReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class QueryUnitInfoByRuleCodeReturnObjResponse {
        /** 单元ID */
        @JsonProperty("unitCode")
        private String unitCode;

        /** 单元名称 */
        @JsonProperty("unitName")
        private String unitName;

        /** 单元别名 */
        @JsonProperty("aliasName")
        private String aliasName;

        /** 备注 */
        @JsonProperty("description")
        private String description;

        /** 日志保留天数 */
        @JsonProperty("ttlDays")
        private Integer ttlDays;

        /** 热存储转冷存储天数 */
        @JsonProperty("tierColdTtl")
        private Integer tierColdTtl;

        /** 创建时间 */
        @JsonProperty("createTime")
        private String createTime;

        public String getUnitCode() {
            return this.unitCode;
        }

        public void setUnitCode(String unitCode) {
            this.unitCode = unitCode;
        }

        public String getUnitName() {
            return this.unitName;
        }

        public void setUnitName(String unitName) {
            this.unitName = unitName;
        }

        public String getAliasName() {
            return this.aliasName;
        }

        public void setAliasName(String aliasName) {
            this.aliasName = aliasName;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Integer getTtlDays() {
            return this.ttlDays;
        }

        public void setTtlDays(Integer ttlDays) {
            this.ttlDays = ttlDays;
        }

        public Integer getTierColdTtl() {
            return this.tierColdTtl;
        }

        public void setTierColdTtl(Integer tierColdTtl) {
            this.tierColdTtl = tierColdTtl;
        }

        public String getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }
    }
}
