package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 根据主机组编码查询主机组名称 */
public class CtltsQueryGroupNameByCodeApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsQueryGroupNameByCodeApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v1/hostGroup/queryNameByCode", "text/plain");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryGroupNameByCodeResponse send(
            Credential credential, QueryGroupNameByCodeRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.hostGroupCodes != null) {
            ctReq.addParam("hostGroupCodes", request.hostGroupCodes);
            request.hostGroupCodes = null;
        }
        ctReq.writeString("", template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryGroupNameByCodeResponse.class);
    }

    public static class QueryGroupNameByCodeRequest {
        /** 资源池编码，请参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 主机组编码列表。创建主机组接口会返回主机组编码，方便后续查找。 */
        @JsonProperty("hostGroupCodes")
        private String hostGroupCodes;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getHostGroupCodes() {
            return this.hostGroupCodes;
        }

        public void setHostGroupCodes(String hostGroupCodes) {
            this.hostGroupCodes = hostGroupCodes;
        }
    }

    public static class QueryGroupNameByCodeResponse {
        /** 响应状态码。0：代表正常； -1：代表严重错误； -2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应结果，主机组名称列表 */
        @JsonProperty("returnObj")
        private List<String> returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public List<String> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<String> returnObj) {
            this.returnObj = returnObj;
        }
    }
}
