package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 项目分页列表 */
public class CtltsProjectPageListApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsProjectPageListApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(ENDPOINT_NAME, "GET", "/v1/project/page", "text/plain");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ProjectPageListResponse send(Credential credential, ProjectPageListRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.projectName != null) {
            ctReq.addParam("projectName", request.projectName);
            request.projectName = null;
        }
        if (request.pageNum != null) {
            ctReq.addParam("pageNum", String.valueOf(request.pageNum));
            request.pageNum = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        ctReq.writeString("", template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ProjectPageListResponse.class);
    }

    public static class ProjectPageListRequest {
        /** 资源池编码，请参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 日志项目原始名称（支持模糊查询）。列表接口会返回日志项目原始名称 */
        @JsonProperty("projectName")
        private String projectName;

        /** 页码，默认1 */
        @JsonProperty("pageNum")
        private Integer pageNum;

        /** 每页大小，默认10 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public Integer getPageNum() {
            return this.pageNum;
        }

        public void setPageNum(Integer pageNum) {
            this.pageNum = pageNum;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class ProjectPageListResponse {
        /** 响应状态码。0：代表正常；-1：代表严重错误；-2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 分页响应对象 */
        @JsonProperty("returnObj")
        private ProjectPageListReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public ProjectPageListReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ProjectPageListReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ProjectPageListReturnObjResponse {
        /** 总记录数 */
        @JsonProperty("total")
        private Long total;

        /** 数据列表 */
        @JsonProperty("list")
        private List<ProjectPageListReturnObjListResponse> list;

        public Long getTotal() {
            return this.total;
        }

        public void setTotal(Long total) {
            this.total = total;
        }

        public List<ProjectPageListReturnObjListResponse> getList() {
            return this.list;
        }

        public void setList(List<ProjectPageListReturnObjListResponse> list) {
            this.list = list;
        }
    }

    public static class ProjectPageListReturnObjListResponse {
        /** 日志项目ID */
        @JsonProperty("projectCode")
        private String projectCode;

        /** 日志项目原始名称 */
        @JsonProperty("projectName")
        private String projectName;

        /** 日志项目名称 */
        @JsonProperty("aliasName")
        private String aliasName;

        /** 日志项目描述 */
        @JsonProperty("description")
        private String description;

        /** 创建时间 */
        @JsonProperty("createTime")
        private String createTime;

        public String getProjectCode() {
            return this.projectCode;
        }

        public void setProjectCode(String projectCode) {
            this.projectCode = projectCode;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public String getAliasName() {
            return this.aliasName;
        }

        public void setAliasName(String aliasName) {
            this.aliasName = aliasName;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }
    }
}
