package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 项目名称列表 */
public class CtltsProjectAliasNameListApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsProjectAliasNameListApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v1/project/queryAliasName", "text/plain");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ProjectAliasNameListResponse send(
            Credential credential, ProjectAliasNameListRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        for (String ele0 : request.projectNameList) {
            if (ele0 != null) {
                ctReq.addParam("projectNameList", ele0);
                ele0 = null;
            }
        }
        ctReq.writeString("", template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ProjectAliasNameListResponse.class);
    }

    public static class ProjectAliasNameListRequest {
        /** 资源池编码，请参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 日志项目原始名称列表。列表接口会返回日志项目原始名称 */
        @JsonProperty("projectNameList")
        private List<String> projectNameList;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public List<String> getProjectNameList() {
            return this.projectNameList;
        }

        public void setProjectNameList(List<String> projectNameList) {
            this.projectNameList = projectNameList;
        }
    }

    public static class ProjectAliasNameListResponse {
        /** 响应状态码。0：代表正常；-1：代表严重错误；-2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求响应数据体 */
        @JsonProperty("returnObj")
        private List<ProjectAliasNameListReturnObjResponse> returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public List<ProjectAliasNameListReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<ProjectAliasNameListReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ProjectAliasNameListReturnObjResponse {
        /** 日志项目原始名称 */
        @JsonProperty("projectName")
        private String projectName;

        /** 日志项目名称 */
        @JsonProperty("projectAliasName")
        private String projectAliasName;

        public String getProjectName() {
            return this.projectName;
        }

        public void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public String getProjectAliasName() {
            return this.projectAliasName;
        }

        public void setProjectAliasName(String projectAliasName) {
            this.projectAliasName = projectAliasName;
        }
    }
}
