package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 该接口用于分页查询指定日志项目ID下的日志单元信息。 */
public class CtltsPageListUnitApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsPageListUnitApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(ENDPOINT_NAME, "GET", "/v1/unit/page", "text/plain");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public PageListUnitResponse send(Credential credential, PageListUnitRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.projectCode != null) {
            ctReq.addParam("projectCode", request.projectCode);
            request.projectCode = null;
        }
        if (request.unitName != null) {
            ctReq.addParam("unitName", request.unitName);
            request.unitName = null;
        }
        if (request.pageNum != null) {
            ctReq.addParam("pageNum", String.valueOf(request.pageNum));
            request.pageNum = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        ctReq.writeString("", template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(PageListUnitResponse.class);
    }

    public static class PageListUnitRequest {
        /** 资源池编码，可参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 日志项目ID。可在云日志控制台 日志管理->日志项目列表->鼠标悬浮查看日志项目ID */
        @JsonProperty("projectCode")
        private String projectCode;

        /** 日志单元原始名称（模糊匹配） */
        @JsonProperty("unitName")
        private String unitName;

        /** 页码（默认1） */
        @JsonProperty("pageNum")
        private Integer pageNum;

        /** 每页记录数量（默认10） */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProjectCode() {
            return this.projectCode;
        }

        public void setProjectCode(String projectCode) {
            this.projectCode = projectCode;
        }

        public String getUnitName() {
            return this.unitName;
        }

        public void setUnitName(String unitName) {
            this.unitName = unitName;
        }

        public Integer getPageNum() {
            return this.pageNum;
        }

        public void setPageNum(Integer pageNum) {
            this.pageNum = pageNum;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class PageListUnitResponse {
        /** 响应状态码。0：代表正常； -1：代表严重错误； -2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private PageListUnitReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public PageListUnitReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(PageListUnitReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class PageListUnitReturnObjResponse {
        /** 数据总数 */
        @JsonProperty("total")
        private Integer total;

        /** 数据列表 */
        @JsonProperty("list")
        private List<PageListUnitReturnObjListResponse> list;

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public List<PageListUnitReturnObjListResponse> getList() {
            return this.list;
        }

        public void setList(List<PageListUnitReturnObjListResponse> list) {
            this.list = list;
        }
    }

    public static class PageListUnitReturnObjListResponse {
        /** 日志单元ID */
        @JsonProperty("unitCode")
        private String unitCode;

        /** 日志单元原始名称 */
        @JsonProperty("unitName")
        private String unitName;

        /** 日志单元名称 */
        @JsonProperty("aliasName")
        private String aliasName;

        /** 描述 */
        @JsonProperty("description")
        private String description;

        /** 存储时长（天） */
        @JsonProperty("ttlDays")
        private String ttlDays;

        /** 创建时间 */
        @JsonProperty("createTime")
        private String createTime;

        public String getUnitCode() {
            return this.unitCode;
        }

        public void setUnitCode(String unitCode) {
            this.unitCode = unitCode;
        }

        public String getUnitName() {
            return this.unitName;
        }

        public void setUnitName(String unitName) {
            this.unitName = unitName;
        }

        public String getAliasName() {
            return this.aliasName;
        }

        public void setAliasName(String aliasName) {
            this.aliasName = aliasName;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getTtlDays() {
            return this.ttlDays;
        }

        public void setTtlDays(String ttlDays) {
            this.ttlDays = ttlDays;
        }

        public String getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }
    }
}
