package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 获取采集规则分页列表 */
public class CtltsPageListCollectRuleApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsPageListCollectRuleApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v1/collectorRule/page", "text/plain");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public PageListCollectRuleResponse send(
            Credential credential, PageListCollectRuleRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.unitCode != null) {
            ctReq.addParam("unitCode", request.unitCode);
            request.unitCode = null;
        }
        if (request.ruleCode != null) {
            ctReq.addParam("ruleCode", request.ruleCode);
            request.ruleCode = null;
        }
        if (request.ruleName != null) {
            ctReq.addParam("ruleName", request.ruleName);
            request.ruleName = null;
        }
        if (request.pageNum != null) {
            ctReq.addParam("pageNum", String.valueOf(request.pageNum));
            request.pageNum = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        ctReq.writeString("", template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(PageListCollectRuleResponse.class);
    }

    public static class PageListCollectRuleRequest {
        /** 资源池编码，请参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 单元ID，可从单元列表获取 */
        @JsonProperty("unitCode")
        private String unitCode;

        /** 采集规则编码，可从采集规则列表获取 */
        @JsonProperty("ruleCode")
        private String ruleCode;

        /** 可根据采集规则名称和原始名称模糊匹配 */
        @JsonProperty("ruleName")
        private String ruleName;

        /** 页码 */
        @JsonProperty("pageNum")
        private Integer pageNum;

        /** 每页记录数 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getUnitCode() {
            return this.unitCode;
        }

        public void setUnitCode(String unitCode) {
            this.unitCode = unitCode;
        }

        public String getRuleCode() {
            return this.ruleCode;
        }

        public void setRuleCode(String ruleCode) {
            this.ruleCode = ruleCode;
        }

        public String getRuleName() {
            return this.ruleName;
        }

        public void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public Integer getPageNum() {
            return this.pageNum;
        }

        public void setPageNum(Integer pageNum) {
            this.pageNum = pageNum;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class PageListCollectRuleResponse {
        /** 响应状态码。0：代表正常；-1：代表严重错误；-2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 规则分页列表 */
        @JsonProperty("returnObj")
        private PageListCollectRuleReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public PageListCollectRuleReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(PageListCollectRuleReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class PageListCollectRuleReturnObjResponse {
        /** 单元ID */
        @JsonProperty("unitCode")
        private String unitCode;

        /** 采集规则原始名称 */
        @JsonProperty("ruleName")
        private String ruleName;

        /** 采集规则编码 */
        @JsonProperty("ruleCode")
        private String ruleCode;

        /** 采集类型，1：云主机-文本日志；2：云容器引擎-标准输出；3：云容器引擎-文本日志；4：syslog-协议; 5: 物理机-文本日志 */
        @JsonProperty("extractMode")
        private Byte extractMode;

        /** 采集路径 */
        @JsonProperty("logPaths")
        private List<String> logPaths;

        /** 切割模式，不同模式对应其他参数不同。1：单行正则；2：分隔符；3：多行正则；4：单行全文；5：json；6：多行全文 */
        @JsonProperty("cuttingMode")
        private String cuttingMode;

        /** 采集规则高级配置 */
        @JsonProperty("ruleConfig")
        private PageListCollectRuleReturnObjRuleConfigResponse ruleConfig;

        /**
         * 接入类型。1：ccse；2：msap；3：csm；4：faas；5：msegw；6：ctgcache；7：kafka；8：mq2；9：amqp；10：host；11：mqtt；12：ebm；13：rcc
         */
        @JsonProperty("accessType")
        private Byte accessType;

        /** 创建时间 */
        @JsonProperty("createTime")
        private String createTime;

        /** 采集策略。all：全量采集；add：增量采集 */
        @JsonProperty("collectPolicy")
        private String collectPolicy;

        public String getUnitCode() {
            return this.unitCode;
        }

        public void setUnitCode(String unitCode) {
            this.unitCode = unitCode;
        }

        public String getRuleName() {
            return this.ruleName;
        }

        public void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public String getRuleCode() {
            return this.ruleCode;
        }

        public void setRuleCode(String ruleCode) {
            this.ruleCode = ruleCode;
        }

        public Byte getExtractMode() {
            return this.extractMode;
        }

        public void setExtractMode(Byte extractMode) {
            this.extractMode = extractMode;
        }

        public List<String> getLogPaths() {
            return this.logPaths;
        }

        public void setLogPaths(List<String> logPaths) {
            this.logPaths = logPaths;
        }

        public String getCuttingMode() {
            return this.cuttingMode;
        }

        public void setCuttingMode(String cuttingMode) {
            this.cuttingMode = cuttingMode;
        }

        public PageListCollectRuleReturnObjRuleConfigResponse getRuleConfig() {
            return this.ruleConfig;
        }

        public void setRuleConfig(PageListCollectRuleReturnObjRuleConfigResponse ruleConfig) {
            this.ruleConfig = ruleConfig;
        }

        public Byte getAccessType() {
            return this.accessType;
        }

        public void setAccessType(Byte accessType) {
            this.accessType = accessType;
        }

        public String getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        public String getCollectPolicy() {
            return this.collectPolicy;
        }

        public void setCollectPolicy(String collectPolicy) {
            this.collectPolicy = collectPolicy;
        }
    }

    public static class PageListCollectRuleReturnObjRuleConfigResponse {
        /** 当采集路径中带"**"通配符时，该参数用于指定"**"通配符最大解析深度 */
        @JsonProperty("maxPathDepth")
        private Integer maxPathDepth;

        /** 文件路径黑名单(排除文件路径符合条件的文件；必须为绝对路径) */
        @JsonProperty("excludeFilePaths")
        private List<String> excludeFilePaths;

        /** 文件黑名单(排除文件名符合条件的文件；必须为文件名，不包含路径) */
        @JsonProperty("excludeFiles")
        private List<String> excludeFiles;

        /** 目录黑名单(排除文件所在目录符合条件的文件；必须为绝对路径) */
        @JsonProperty("excludeDirs")
        private List<String> excludeDirs;

        /** 分隔符，当切割模式为分隔符时返回 */
        @JsonProperty("delimiter")
        private PageListCollectRuleReturnObjRuleConfigDelimiterResponse delimiter;

        /** 正则切割模式：当切割模式为正则时返回 */
        @JsonProperty("regex")
        private String regex;

        public Integer getMaxPathDepth() {
            return this.maxPathDepth;
        }

        public void setMaxPathDepth(Integer maxPathDepth) {
            this.maxPathDepth = maxPathDepth;
        }

        public List<String> getExcludeFilePaths() {
            return this.excludeFilePaths;
        }

        public void setExcludeFilePaths(List<String> excludeFilePaths) {
            this.excludeFilePaths = excludeFilePaths;
        }

        public List<String> getExcludeFiles() {
            return this.excludeFiles;
        }

        public void setExcludeFiles(List<String> excludeFiles) {
            this.excludeFiles = excludeFiles;
        }

        public List<String> getExcludeDirs() {
            return this.excludeDirs;
        }

        public void setExcludeDirs(List<String> excludeDirs) {
            this.excludeDirs = excludeDirs;
        }

        public PageListCollectRuleReturnObjRuleConfigDelimiterResponse getDelimiter() {
            return this.delimiter;
        }

        public void setDelimiter(
                PageListCollectRuleReturnObjRuleConfigDelimiterResponse delimiter) {
            this.delimiter = delimiter;
        }

        public String getRegex() {
            return this.regex;
        }

        public void setRegex(String regex) {
            this.regex = regex;
        }
    }

    public static class PageListCollectRuleReturnObjRuleConfigDelimiterResponse {
        /** 分隔符 */
        @JsonProperty("delimiter")
        private String delimiter;

        /** 分割所得类型字段，输入顺序会被使用 */
        @JsonProperty("logContent")
        private List<PageListCollectRuleReturnObjRuleConfigDelimiterLogContentResponse> logContent;

        public String getDelimiter() {
            return this.delimiter;
        }

        public void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        public List<PageListCollectRuleReturnObjRuleConfigDelimiterLogContentResponse>
                getLogContent() {
            return this.logContent;
        }

        public void setLogContent(
                List<PageListCollectRuleReturnObjRuleConfigDelimiterLogContentResponse>
                        logContent) {
            this.logContent = logContent;
        }
    }

    public static class PageListCollectRuleReturnObjRuleConfigDelimiterLogContentResponse {
        /** 提取字段 */
        @JsonProperty("key")
        private String key;

        /** 数据类型。text：字符串；double：数字 */
        @JsonProperty("type")
        private String type;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}
