package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 分页获取仪表盘订阅任务。 */
public class CtltsPageDashboardSubscribeApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsPageDashboardSubscribeApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v1/dashboard/subscribe/page", "text/plain");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public PageDashboardSubscribeResponse send(
            Credential credential, PageDashboardSubscribeRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.pageNum != null) {
            ctReq.addParam("pageNum", String.valueOf(request.pageNum));
            request.pageNum = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        if (request.dashboardCodeList != null) {
            ctReq.addParam("dashboardCodeList", request.dashboardCodeList);
            request.dashboardCodeList = null;
        }
        if (request.subscriptionCodeList != null) {
            ctReq.addParam("subscriptionCodeList", request.subscriptionCodeList);
            request.subscriptionCodeList = null;
        }
        ctReq.writeString("", template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(PageDashboardSubscribeResponse.class);
    }

    public static class PageDashboardSubscribeRequest {
        /** 资源池编码，可参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 分页页码，默认为1。 */
        @JsonProperty("pageNum")
        private Integer pageNum;

        /** 分页大小，默认为10。 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /**
         * 仪表盘编码列表，英文（半角）逗号分割。仪表盘编码可以在创建仪表盘（dashboardCreate）时或者从获取仪表盘编码接口（getDashboardByName）、仪表盘列表接口获取（listDashboard）。
         */
        @JsonProperty("dashboardCodeList")
        private String dashboardCodeList;

        /** 订阅编码列表，英文（半角）逗号分割。订阅任务编码。可以从列取仪表盘订阅接口（listDashboardSubscribe）获取。 */
        @JsonProperty("subscriptionCodeList")
        private String subscriptionCodeList;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public Integer getPageNum() {
            return this.pageNum;
        }

        public void setPageNum(Integer pageNum) {
            this.pageNum = pageNum;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public String getDashboardCodeList() {
            return this.dashboardCodeList;
        }

        public void setDashboardCodeList(String dashboardCodeList) {
            this.dashboardCodeList = dashboardCodeList;
        }

        public String getSubscriptionCodeList() {
            return this.subscriptionCodeList;
        }

        public void setSubscriptionCodeList(String subscriptionCodeList) {
            this.subscriptionCodeList = subscriptionCodeList;
        }
    }

    public static class PageDashboardSubscribeResponse {
        /** 响应状态码。0：正常；-1：代表严重错误；-2：代表普通错误。 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 消息内容。 */
        @JsonProperty("message")
        private String message;

        /** 请求ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 订阅分页数据。 */
        @JsonProperty("returnObj")
        private PageDashboardSubscribeReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public PageDashboardSubscribeReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(PageDashboardSubscribeReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class PageDashboardSubscribeReturnObjResponse {
        /** 订阅数。 */
        @JsonProperty("total")
        private Integer total;

        /** 数据列表。 */
        @JsonProperty("list")
        private List<PageDashboardSubscribeReturnObjListResponse> list;

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public List<PageDashboardSubscribeReturnObjListResponse> getList() {
            return this.list;
        }

        public void setList(List<PageDashboardSubscribeReturnObjListResponse> list) {
            this.list = list;
        }
    }

    public static class PageDashboardSubscribeReturnObjListResponse {
        /** 订阅编码。 */
        @JsonProperty("code")
        private String code;

        /** 订阅名称。 */
        @JsonProperty("name")
        private String name;

        /** 仪表盘编码。 */
        @JsonProperty("dashboardCode")
        private String dashboardCode;

        /** 定时任务表达式。 */
        @JsonProperty("crontab")
        private PageDashboardSubscribeReturnObjListCrontabResponse crontab;

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDashboardCode() {
            return this.dashboardCode;
        }

        public void setDashboardCode(String dashboardCode) {
            this.dashboardCode = dashboardCode;
        }

        public PageDashboardSubscribeReturnObjListCrontabResponse getCrontab() {
            return this.crontab;
        }

        public void setCrontab(PageDashboardSubscribeReturnObjListCrontabResponse crontab) {
            this.crontab = crontab;
        }
    }

    public static class PageDashboardSubscribeReturnObjListCrontabResponse {
        /** 类型，week：按每周运行；month：按每月运行；day：按每天运行。 */
        @JsonProperty("type")
        private String type;

        /** 按每周运行时，数值1，2，...7代表周一到周日。 */
        @JsonProperty("week")
        private Integer week;

        /** 按每月运行时，对应的第N天。 */
        @JsonProperty("day")
        private Integer day;

        /** 按每天运行时，对应的发送的时间。 */
        @JsonProperty("time")
        private String time;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Integer getWeek() {
            return this.week;
        }

        public void setWeek(Integer week) {
            this.week = week;
        }

        public Integer getDay() {
            return this.day;
        }

        public void setDay(Integer day) {
            this.day = day;
        }

        public String getTime() {
            return this.time;
        }

        public void setTime(String time) {
            this.time = time;
        }
    }
}
