package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 开通日志服务 */
public class CtltsOpenLtsApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsOpenLtsApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/v1/order/instance/open", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public OpenLtsResponse send(Credential credential, OpenLtsRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(OpenLtsResponse.class);
    }

    public static class OpenLtsRequest {
        /** 资源池编码，请参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 计费模式。1：包周期；2：按需，默认是2。 */
        @JsonProperty("billMode")
        private Byte billMode;

        /** 资源包规格。1CU可用于抵扣1元人民币对应的计费项资源用量。取值范围：[10，100，500，1000，5000，10000]。包周期必填 */
        @JsonProperty("cuNum")
        private Integer cuNum;

        /** 资源包订购周期。cycleCnt为1表示订购1个月，取值范围：[1，3，6，12，24，36]。包周期必填 */
        @JsonProperty("cycleCnt")
        private Integer cycleCnt;

        /** 资源包订购数量。默认值1，最大99。 */
        @JsonProperty("pakageCnt")
        private Integer pakageCnt;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public Byte getBillMode() {
            return this.billMode;
        }

        public void setBillMode(Byte billMode) {
            this.billMode = billMode;
        }

        public Integer getCuNum() {
            return this.cuNum;
        }

        public void setCuNum(Integer cuNum) {
            this.cuNum = cuNum;
        }

        public Integer getCycleCnt() {
            return this.cycleCnt;
        }

        public void setCycleCnt(Integer cycleCnt) {
            this.cycleCnt = cycleCnt;
        }

        public Integer getPakageCnt() {
            return this.pakageCnt;
        }

        public void setPakageCnt(Integer pakageCnt) {
            this.pakageCnt = pakageCnt;
        }
    }

    public static class OpenLtsResponse {
        /** 响应状态码。0：代表正常；-1：代表严重错误；-2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求响应数据体 */
        @JsonProperty("returnObj")
        private OpenLtsReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public OpenLtsReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(OpenLtsReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class OpenLtsReturnObjResponse {}
}
