package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 列出指定Project下的加工任务 */
public class CtltsListProcessTaskApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsListProcessTaskApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v1/dataProcess/listProcessTask", "text/plain");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ListProcessTaskResponse send(Credential credential, ListProcessTaskRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.projectCode != null) {
            ctReq.addParam("projectCode", request.projectCode);
            request.projectCode = null;
        }
        if (request.pageNum != null) {
            ctReq.addParam("pageNum", String.valueOf(request.pageNum));
            request.pageNum = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        ctReq.writeString("", template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ListProcessTaskResponse.class);
    }

    public static class ListProcessTaskRequest {
        /** 资源池编码，可参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 日志项目ID 可在云日志控制台 日志管理 -> 日志项目列表 -> 鼠标悬浮查看日志项目ID */
        @JsonProperty("projectCode")
        private String projectCode;

        /** 页码 默认1 */
        @JsonProperty("pageNum")
        private Integer pageNum;

        /** 每页大小 默认10 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProjectCode() {
            return this.projectCode;
        }

        public void setProjectCode(String projectCode) {
            this.projectCode = projectCode;
        }

        public Integer getPageNum() {
            return this.pageNum;
        }

        public void setPageNum(Integer pageNum) {
            this.pageNum = pageNum;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class ListProcessTaskResponse {
        /** 响应状态码。0：代表正常； -1：代表严重错误； -2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码,仅错误时返回,例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 消息内容 */
        @JsonProperty("message")
        private String message;

        /** 请求接口返回的数据体 */
        @JsonProperty("returnObj")
        private ListProcessTaskReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public ListProcessTaskReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ListProcessTaskReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ListProcessTaskReturnObjResponse {
        /** 总记录数 */
        @JsonProperty("total")
        private Integer total;

        /** 数据列表 */
        @JsonProperty("list")
        private List<ListProcessTaskReturnObjListResponse> list;

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public List<ListProcessTaskReturnObjListResponse> getList() {
            return this.list;
        }

        public void setList(List<ListProcessTaskReturnObjListResponse> list) {
            this.list = list;
        }
    }

    public static class ListProcessTaskReturnObjListResponse {
        /** 任务ID */
        @JsonProperty("taskCode")
        private String taskCode;

        /** 任务名称 */
        @JsonProperty("taskName")
        private String taskName;

        /** 源日志项目ID */
        @JsonProperty("projectCode")
        private String projectCode;

        /** 源日志项目名称 */
        @JsonProperty("projectName")
        private String projectName;

        /** 源日志单元ID */
        @JsonProperty("unitCode")
        private String unitCode;

        /** 源日志单元名称 */
        @JsonProperty("unitName")
        private String unitName;

        /** 加工范围： CONTINUE-某时间开始【默认选中】 RANGE-特定时间范围 */
        @JsonProperty("processRange")
        private String processRange;

        /** 加工开始时间[毫秒] */
        @JsonProperty("startTime")
        private Long startTime;

        /** 加工结束时间[毫秒] */
        @JsonProperty("endTime")
        private Long endTime;

        /** 任务状态：STARING-启动中 RUNNING-运行中 SUCCESS-成功 FAIL-失败 STOPPING-停止中 STOPPED-已终止 */
        @JsonProperty("status")
        private String status;

        /** 创建时间[毫秒] */
        @JsonProperty("createTime")
        private Integer createTime;

        public String getTaskCode() {
            return this.taskCode;
        }

        public void setTaskCode(String taskCode) {
            this.taskCode = taskCode;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public void setTaskName(String taskName) {
            this.taskName = taskName;
        }

        public String getProjectCode() {
            return this.projectCode;
        }

        public void setProjectCode(String projectCode) {
            this.projectCode = projectCode;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public String getUnitCode() {
            return this.unitCode;
        }

        public void setUnitCode(String unitCode) {
            this.unitCode = unitCode;
        }

        public String getUnitName() {
            return this.unitName;
        }

        public void setUnitName(String unitName) {
            this.unitName = unitName;
        }

        public String getProcessRange() {
            return this.processRange;
        }

        public void setProcessRange(String processRange) {
            this.processRange = processRange;
        }

        public Long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public Long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public Integer getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Integer createTime) {
            this.createTime = createTime;
        }
    }
}
