package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 列出指定项目下的对象存储投递任务。 */
public class CtltsListOSSDataSendTaskApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsListOSSDataSendTaskApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v1/dataSend/listOSSTask", "text/plain");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ListOSSDataSendTaskResponse send(
            Credential credential, ListOSSDataSendTaskRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.projectCode != null) {
            ctReq.addParam("projectCode", request.projectCode);
            request.projectCode = null;
        }
        if (request.pageNum != null) {
            ctReq.addParam("pageNum", String.valueOf(request.pageNum));
            request.pageNum = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        ctReq.writeString("", template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ListOSSDataSendTaskResponse.class);
    }

    public static class ListOSSDataSendTaskRequest {
        /** 资源池编码，可参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 项目ID，可通过获取项目列表接口获取 */
        @JsonProperty("projectCode")
        private String projectCode;

        /** 页码，默认：1 */
        @JsonProperty("pageNum")
        private Integer pageNum;

        /** 每页数量， 默认：10 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProjectCode() {
            return this.projectCode;
        }

        public void setProjectCode(String projectCode) {
            this.projectCode = projectCode;
        }

        public Integer getPageNum() {
            return this.pageNum;
        }

        public void setPageNum(Integer pageNum) {
            this.pageNum = pageNum;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class ListOSSDataSendTaskResponse {
        /** 响应状态码。0：代表正常； -1：代表严重错误； -2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求id */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求返回体 */
        @JsonProperty("returnObj")
        private ListOSSDataSendTaskReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public ListOSSDataSendTaskReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ListOSSDataSendTaskReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ListOSSDataSendTaskReturnObjResponse {
        /** 返回总数 */
        @JsonProperty("total")
        private Integer total;

        /** 投递任务列表 */
        @JsonProperty("list")
        private List<ListOSSDataSendTaskReturnObjListResponse> list;

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public List<ListOSSDataSendTaskReturnObjListResponse> getList() {
            return this.list;
        }

        public void setList(List<ListOSSDataSendTaskReturnObjListResponse> list) {
            this.list = list;
        }
    }

    public static class ListOSSDataSendTaskReturnObjListResponse {
        /** 任务编码 */
        @JsonProperty("taskCode")
        private String taskCode;

        /** 任务名称 */
        @JsonProperty("taskName")
        private String taskName;

        /** 投递任务配置 */
        @JsonProperty("instanceConfig")
        private ListOSSDataSendTaskReturnObjListInstanceConfigResponse instanceConfig;

        /** 项目ID */
        @JsonProperty("projectCode")
        private String projectCode;

        /** 项目名称 */
        @JsonProperty("projectName")
        private String projectName;

        /** 单元ID */
        @JsonProperty("unitCode")
        private String unitCode;

        /** 单元名称 */
        @JsonProperty("unitName")
        private String unitName;

        /** 投递类型。CONTINUOUS：持续投递; RANGE：指定时间点结束 */
        @JsonProperty("processRange")
        private String processRange;

        /** 投递开始时间[毫秒] */
        @JsonProperty("startTime")
        private Long startTime;

        /** 投递结束时间[毫秒] */
        @JsonProperty("endTime")
        private Long endTime;

        /**
         * 任务状态。STARTING：启动中；RUNNING：运行中；SUCCESS：完成；FAIL：失败；STOPPING：停止中；STOPPED：已停止；MODIFIED：修改中
         */
        @JsonProperty("status")
        private String status;

        /** 任务创建时间[毫秒] */
        @JsonProperty("createTime")
        private Long createTime;

        public String getTaskCode() {
            return this.taskCode;
        }

        public void setTaskCode(String taskCode) {
            this.taskCode = taskCode;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public void setTaskName(String taskName) {
            this.taskName = taskName;
        }

        public ListOSSDataSendTaskReturnObjListInstanceConfigResponse getInstanceConfig() {
            return this.instanceConfig;
        }

        public void setInstanceConfig(
                ListOSSDataSendTaskReturnObjListInstanceConfigResponse instanceConfig) {
            this.instanceConfig = instanceConfig;
        }

        public String getProjectCode() {
            return this.projectCode;
        }

        public void setProjectCode(String projectCode) {
            this.projectCode = projectCode;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public String getUnitCode() {
            return this.unitCode;
        }

        public void setUnitCode(String unitCode) {
            this.unitCode = unitCode;
        }

        public String getUnitName() {
            return this.unitName;
        }

        public void setUnitName(String unitName) {
            this.unitName = unitName;
        }

        public String getProcessRange() {
            return this.processRange;
        }

        public void setProcessRange(String processRange) {
            this.processRange = processRange;
        }

        public Long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public Long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public Long getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Long createTime) {
            this.createTime = createTime;
        }
    }

    public static class ListOSSDataSendTaskReturnObjListInstanceConfigResponse {
        /** 桶名 */
        @JsonProperty("bucketName")
        private String bucketName;

        /** 对象存储地址 */
        @JsonProperty("endpoint")
        private String endpoint;

        /** 投递文件分区格式，默认 %Y/%m/%d/%H/%M */
        @JsonProperty("pattern")
        private String pattern;

        /** 投递文件存放路径目录，从应用日志服务转储到对象存储的数据将存放到Bucket的该目录下，若未设置，则默认在根目录下，不能以斜线开头 */
        @JsonProperty("path")
        private String path;

        /** 投递时间间隔[秒]，默认300，最小300 最大600 */
        @JsonProperty("timeInterval")
        private Integer timeInterval;

        /** 投递文件格式，暂时只支持JSON */
        @JsonProperty("saveFormat")
        private String saveFormat;

        /** 投递文件大小[MB]，默认256，最小5 最大256 */
        @JsonProperty("size")
        private Integer size;

        /** 投递文件是否压缩， 默认为true */
        @JsonProperty("iscompress")
        private Boolean iscompress;

        /**
         * 投递文件压缩格式，仅在iscompress为true时，生效。gzip：gzip压缩；snappy：snappy压缩；lz4：lz4压缩；zstd：zstd压缩。默认gzip
         */
        @JsonProperty("compressType")
        private String compressType;

        public String getBucketName() {
            return this.bucketName;
        }

        public void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public Integer getTimeInterval() {
            return this.timeInterval;
        }

        public void setTimeInterval(Integer timeInterval) {
            this.timeInterval = timeInterval;
        }

        public String getSaveFormat() {
            return this.saveFormat;
        }

        public void setSaveFormat(String saveFormat) {
            this.saveFormat = saveFormat;
        }

        public Integer getSize() {
            return this.size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public Boolean getIscompress() {
            return this.iscompress;
        }

        public void setIscompress(Boolean iscompress) {
            this.iscompress = iscompress;
        }

        public String getCompressType() {
            return this.compressType;
        }

        public void setCompressType(String compressType) {
            this.compressType = compressType;
        }
    }
}
