package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 标签列表 */
public class CtltsListLabelOfResourceApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsListLabelOfResourceApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(ENDPOINT_NAME, "GET", "/v1/tags/list", "text/plain");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ListLabelOfResourceResponse send(
            Credential credential, ListLabelOfResourceRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.baseResourceIdList != null) {
            ctReq.addParam("baseResourceIdList", request.baseResourceIdList);
            request.baseResourceIdList = null;
        }
        ctReq.writeString("", template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ListLabelOfResourceResponse.class);
    }

    public static class ListLabelOfResourceRequest {
        /** 资源池编码，请参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 资源标识列表（例如：项目ID列表） */
        @JsonProperty("baseResourceIdList")
        private String baseResourceIdList;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getBaseResourceIdList() {
            return this.baseResourceIdList;
        }

        public void setBaseResourceIdList(String baseResourceIdList) {
            this.baseResourceIdList = baseResourceIdList;
        }
    }

    public static class ListLabelOfResourceResponse {
        /** 响应状态码。0：代表正常；-1：代表严重错误；-2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求响应数据体 */
        @JsonProperty("returnObj")
        private List<ListLabelOfResourceReturnObjResponse> returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public List<ListLabelOfResourceReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<ListLabelOfResourceReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ListLabelOfResourceReturnObjResponse {
        /** 标签名 */
        @JsonProperty("key")
        private String key;

        /** 标签值 */
        @JsonProperty("value")
        private String value;

        /** 标签ID */
        @JsonProperty("labelId")
        private String labelId;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getLabelId() {
            return this.labelId;
        }

        public void setLabelId(String labelId) {
            this.labelId = labelId;
        }
    }
}
