package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 导入任务列表查询, 支持分页 */
public class CtltsListImportTaskApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsListImportTaskApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(ENDPOINT_NAME, "GET", "/v1/import/list", "text/plain");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ListImportTaskResponse send(Credential credential, ListImportTaskRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.name != null) {
            ctReq.addParam("name", request.name);
            request.name = null;
        }
        if (request.code != null) {
            ctReq.addParam("code", request.code);
            request.code = null;
        }
        if (request.type != null) {
            ctReq.addParam("type", request.type);
            request.type = null;
        }
        if (request.unitCode != null) {
            ctReq.addParam("unitCode", request.unitCode);
            request.unitCode = null;
        }
        if (request.pageNum != null) {
            ctReq.addParam("pageNum", String.valueOf(request.pageNum));
            request.pageNum = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        ctReq.writeString("", template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ListImportTaskResponse.class);
    }

    public static class ListImportTaskRequest {
        /** 资源池编码，可参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 导入任务名称, 支持模糊匹配 */
        @JsonProperty("name")
        private String name;

        /** 任务编码，创建导入任务时返回 */
        @JsonProperty("code")
        private String code;

        /** 导入任务类型, 支持传入KAFKA和OSS两种类型 */
        @JsonProperty("type")
        private String type;

        /** 导入任务所属日志单元编码 */
        @JsonProperty("unitCode")
        private String unitCode;

        /** 页码 默认1 */
        @JsonProperty("pageNum")
        private Integer pageNum;

        /** 每页大小 默认10 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getUnitCode() {
            return this.unitCode;
        }

        public void setUnitCode(String unitCode) {
            this.unitCode = unitCode;
        }

        public Integer getPageNum() {
            return this.pageNum;
        }

        public void setPageNum(Integer pageNum) {
            this.pageNum = pageNum;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class ListImportTaskResponse {
        /** 响应状态码。0：代表正常； -1：代表严重错误； -2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 调用错误时返回的错误编码 */
        @JsonProperty("error")
        private String error;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 消息内容 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private ListImportTaskReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public ListImportTaskReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ListImportTaskReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ListImportTaskReturnObjResponse {
        /** 总记录数 */
        @JsonProperty("total")
        private Integer total;

        /** 数据列表 */
        @JsonProperty("list")
        private List<ListImportTaskReturnObjListResponse> list;

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public List<ListImportTaskReturnObjListResponse> getList() {
            return this.list;
        }

        public void setList(List<ListImportTaskReturnObjListResponse> list) {
            this.list = list;
        }
    }

    public static class ListImportTaskReturnObjListResponse {
        /** 导入任务名称 */
        @JsonProperty("name")
        private String name;

        /** 导入任务编码 */
        @JsonProperty("code")
        private String code;

        /** 导入任务类型 */
        @JsonProperty("type")
        private String type;

        /** 单元编码 */
        @JsonProperty("unitCode")
        private String unitCode;

        /** 创建时间 */
        @JsonProperty("createTime")
        private String createTime;

        /** oss导入配置信息 */
        @JsonProperty("ossTaskConfig")
        private ListImportTaskReturnObjListOssTaskConfigResponse ossTaskConfig;

        /** kafka导入配置信息 */
        @JsonProperty("kafkaTaskConfig")
        private ListImportTaskReturnObjListKafkaTaskConfigResponse kafkaTaskConfig;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getUnitCode() {
            return this.unitCode;
        }

        public void setUnitCode(String unitCode) {
            this.unitCode = unitCode;
        }

        public String getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        public ListImportTaskReturnObjListOssTaskConfigResponse getOssTaskConfig() {
            return this.ossTaskConfig;
        }

        public void setOssTaskConfig(
                ListImportTaskReturnObjListOssTaskConfigResponse ossTaskConfig) {
            this.ossTaskConfig = ossTaskConfig;
        }

        public ListImportTaskReturnObjListKafkaTaskConfigResponse getKafkaTaskConfig() {
            return this.kafkaTaskConfig;
        }

        public void setKafkaTaskConfig(
                ListImportTaskReturnObjListKafkaTaskConfigResponse kafkaTaskConfig) {
            this.kafkaTaskConfig = kafkaTaskConfig;
        }
    }

    public static class ListImportTaskReturnObjListOssTaskConfigResponse {
        /** bucket名称 */
        @JsonProperty("bucket")
        private String bucket;

        /** 文件检查周期配置 */
        @JsonProperty("customCheckCycle")
        private ListImportTaskReturnObjListOssTaskConfigCustomCheckCycleResponse customCheckCycle;

        /** 是否开启oss文件检测, true：开启；false：不开启 */
        @JsonProperty("enableCheckTask")
        private Boolean enableCheckTask;

        /** 路径前缀匹配 */
        @JsonProperty("pathPrefix")
        private String pathPrefix;

        /** 文件正则过滤 */
        @JsonProperty("pathPattern")
        private String pathPattern;

        /** 文件编码 */
        @JsonProperty("encoding")
        private String encoding;

        /** 文件正则表达式 */
        @JsonProperty("regex")
        private ListImportTaskReturnObjListOssTaskConfigRegexResponse regex;

        /** 文件提取模式 */
        @JsonProperty("format")
        private ListImportTaskReturnObjListOssTaskConfigFormatResponse format;

        public String getBucket() {
            return this.bucket;
        }

        public void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public ListImportTaskReturnObjListOssTaskConfigCustomCheckCycleResponse
                getCustomCheckCycle() {
            return this.customCheckCycle;
        }

        public void setCustomCheckCycle(
                ListImportTaskReturnObjListOssTaskConfigCustomCheckCycleResponse customCheckCycle) {
            this.customCheckCycle = customCheckCycle;
        }

        public Boolean getEnableCheckTask() {
            return this.enableCheckTask;
        }

        public void setEnableCheckTask(Boolean enableCheckTask) {
            this.enableCheckTask = enableCheckTask;
        }

        public String getPathPrefix() {
            return this.pathPrefix;
        }

        public void setPathPrefix(String pathPrefix) {
            this.pathPrefix = pathPrefix;
        }

        public String getPathPattern() {
            return this.pathPattern;
        }

        public void setPathPattern(String pathPattern) {
            this.pathPattern = pathPattern;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public ListImportTaskReturnObjListOssTaskConfigRegexResponse getRegex() {
            return this.regex;
        }

        public void setRegex(ListImportTaskReturnObjListOssTaskConfigRegexResponse regex) {
            this.regex = regex;
        }

        public ListImportTaskReturnObjListOssTaskConfigFormatResponse getFormat() {
            return this.format;
        }

        public void setFormat(ListImportTaskReturnObjListOssTaskConfigFormatResponse format) {
            this.format = format;
        }
    }

    public static class ListImportTaskReturnObjListKafkaTaskConfigResponse {
        /** kafka导入topic列表 */
        @JsonProperty("topics")
        private List<String> topics;

        /** 消费者组名称 */
        @JsonProperty("consumerGroup")
        private String consumerGroup;

        /** 消费起始位置, 返回oldest和newest */
        @JsonProperty("offset")
        private String offset;

        public List<String> getTopics() {
            return this.topics;
        }

        public void setTopics(List<String> topics) {
            this.topics = topics;
        }

        public String getConsumerGroup() {
            return this.consumerGroup;
        }

        public void setConsumerGroup(String consumerGroup) {
            this.consumerGroup = consumerGroup;
        }

        public String getOffset() {
            return this.offset;
        }

        public void setOffset(String offset) {
            this.offset = offset;
        }
    }

    public static class ListImportTaskReturnObjListOssTaskConfigCustomCheckCycleResponse {
        /** 定时任务周期单位, 支持传入minute：分钟；day：天；hour：小时, 与时间间隔一起使用 */
        @JsonProperty("unit")
        private String unit;

        /** 时间间隔, 与任务周期单位一起使用 */
        @JsonProperty("interval")
        private Integer interval;

        public String getUnit() {
            return this.unit;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        public Integer getInterval() {
            return this.interval;
        }

        public void setInterval(Integer interval) {
            this.interval = interval;
        }
    }

    public static class ListImportTaskReturnObjListOssTaskConfigRegexResponse {
        /** 提取正则, 单行正则或多行正则提取模式下必填 */
        @JsonProperty("regexStr")
        private String regexStr;

        /** 日志提取内容 */
        @JsonProperty("logContent")
        private List<ListImportTaskReturnObjListOssTaskConfigRegexLogContentResponse> logContent;

        public String getRegexStr() {
            return this.regexStr;
        }

        public void setRegexStr(String regexStr) {
            this.regexStr = regexStr;
        }

        public List<ListImportTaskReturnObjListOssTaskConfigRegexLogContentResponse>
                getLogContent() {
            return this.logContent;
        }

        public void setLogContent(
                List<ListImportTaskReturnObjListOssTaskConfigRegexLogContentResponse> logContent) {
            this.logContent = logContent;
        }
    }

    public static class ListImportTaskReturnObjListOssTaskConfigFormatResponse {
        /** 返回TEXT, MULTI_TEXT, JSON3种类型 */
        @JsonProperty("type")
        private String type;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    public static class ListImportTaskReturnObjListOssTaskConfigRegexLogContentResponse {
        /** 提取字段 */
        @JsonProperty("key")
        private String key;

        /** 数据类型。text：字符串；double：数字 */
        @JsonProperty("type")
        private String type;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}
