package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 列取仪表盘订阅任务。 */
public class CtltsListDashboardSubscribeApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsListDashboardSubscribeApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v1/dashboard/subscribe/list", "text/plain");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ListDashboardSubscribeResponse send(
            Credential credential, ListDashboardSubscribeRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.dashboardCodeList != null) {
            ctReq.addParam("dashboardCodeList", request.dashboardCodeList);
            request.dashboardCodeList = null;
        }
        if (request.subscriptionCodeList != null) {
            ctReq.addParam("subscriptionCodeList", request.subscriptionCodeList);
            request.subscriptionCodeList = null;
        }
        ctReq.writeString("", template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ListDashboardSubscribeResponse.class);
    }

    public static class ListDashboardSubscribeRequest {
        /** 资源池编码，可参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 仪表盘编码列表，英文（半角）逗号分割。 */
        @JsonProperty("dashboardCodeList")
        private String dashboardCodeList;

        /** 订阅编码列表，英文（半角）逗号分割。 */
        @JsonProperty("subscriptionCodeList")
        private String subscriptionCodeList;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getDashboardCodeList() {
            return this.dashboardCodeList;
        }

        public void setDashboardCodeList(String dashboardCodeList) {
            this.dashboardCodeList = dashboardCodeList;
        }

        public String getSubscriptionCodeList() {
            return this.subscriptionCodeList;
        }

        public void setSubscriptionCodeList(String subscriptionCodeList) {
            this.subscriptionCodeList = subscriptionCodeList;
        }
    }

    public static class ListDashboardSubscribeResponse {
        /** 响应状态码。0：正常；-1：代表严重错误；-2：代表普通错误。 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 消息内容。 */
        @JsonProperty("message")
        private String message;

        /** 请求ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 订阅任务列表。 */
        @JsonProperty("returnObj")
        private List<ListDashboardSubscribeReturnObjResponse> returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public List<ListDashboardSubscribeReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<ListDashboardSubscribeReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ListDashboardSubscribeReturnObjResponse {
        /** 订阅编码。 */
        @JsonProperty("code")
        private String code;

        /** 订阅名称。 */
        @JsonProperty("name")
        private String name;

        /** 仪表盘编码。 */
        @JsonProperty("dashboardCode")
        private String dashboardCode;

        /** 定时任务时间对象。 */
        @JsonProperty("crontab")
        private ListDashboardSubscribeReturnObjCrontabResponse crontab;

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDashboardCode() {
            return this.dashboardCode;
        }

        public void setDashboardCode(String dashboardCode) {
            this.dashboardCode = dashboardCode;
        }

        public ListDashboardSubscribeReturnObjCrontabResponse getCrontab() {
            return this.crontab;
        }

        public void setCrontab(ListDashboardSubscribeReturnObjCrontabResponse crontab) {
            this.crontab = crontab;
        }
    }

    public static class ListDashboardSubscribeReturnObjCrontabResponse {
        /** 类型，week：按每周运行；month：按每月运行；day：按每天运行。 */
        @JsonProperty("type")
        private String type;

        /** 按每周运行时，数值1，2，...7代表周一到周日。 */
        @JsonProperty("week")
        private Integer week;

        /** 按每月运行时，对应的第N天。 */
        @JsonProperty("day")
        private Integer day;

        /** 按每天运行时，对应的发送的时间。 */
        @JsonProperty("time")
        private String time;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Integer getWeek() {
            return this.week;
        }

        public void setWeek(Integer week) {
            this.week = week;
        }

        public Integer getDay() {
            return this.day;
        }

        public void setDay(Integer day) {
            this.day = day;
        }

        public String getTime() {
            return this.time;
        }

        public void setTime(String time) {
            this.time = time;
        }
    }
}
