package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 列出某个消费组的日志单元列表。（邀测功能，仅白名单用户可调用） */
public class CtltsListConsumerGroupBindUnitApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsListConsumerGroupBindUnitApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v1/consumerGroup/listBindUnit", "text/plain");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ListConsumerGroupBindUnitResponse send(
            Credential credential, ListConsumerGroupBindUnitRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.groupName != null) {
            ctReq.addParam("groupName", request.groupName);
            request.groupName = null;
        }
        ctReq.writeString("", template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ListConsumerGroupBindUnitResponse.class);
    }

    public static class ListConsumerGroupBindUnitRequest {
        /** 资源池编码，可参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 消费组名称（完整名称）。可在云日志控制台 日志消费 -> 消费组配置 表格中查看。 */
        @JsonProperty("groupName")
        private String groupName;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public void setGroupName(String groupName) {
            this.groupName = groupName;
        }
    }

    public static class ListConsumerGroupBindUnitResponse {
        /** 响应状态码。0：代表正常； -1：代表严重错误； -2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 绑定的日志单元对象列表 */
        @JsonProperty("returnObj")
        private List<ListConsumerGroupBindUnitReturnObjResponse> returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public List<ListConsumerGroupBindUnitReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<ListConsumerGroupBindUnitReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ListConsumerGroupBindUnitReturnObjResponse {
        /** 关联的日志项目名称 */
        @JsonProperty("projectName")
        private String projectName;

        /** 关联的日志项目ID */
        @JsonProperty("projectCode")
        private String projectCode;

        /** 关联的日志单元名称 */
        @JsonProperty("unitName")
        private String unitName;

        /** 关联的日志单元ID */
        @JsonProperty("unitCode")
        private String unitCode;

        /** 消费组绑定日志单元的状态。0：代表停用；1：代表正常；2：代表删除中 */
        @JsonProperty("status")
        private Integer status;

        public String getProjectName() {
            return this.projectName;
        }

        public void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public String getProjectCode() {
            return this.projectCode;
        }

        public void setProjectCode(String projectCode) {
            this.projectCode = projectCode;
        }

        public String getUnitName() {
            return this.unitName;
        }

        public void setUnitName(String unitName) {
            this.unitName = unitName;
        }

        public String getUnitCode() {
            return this.unitCode;
        }

        public void setUnitCode(String unitCode) {
            this.unitCode = unitCode;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }
    }
}
