package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 采集规则列表 */
public class CtltsListCollectRuleApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsListCollectRuleApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v1/collectorRule/list", "text/plain");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ListCollectRuleResponse send(Credential credential, ListCollectRuleRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.unitCode != null) {
            ctReq.addParam("unitCode", request.unitCode);
            request.unitCode = null;
        }
        if (request.ruleCode != null) {
            ctReq.addParam("ruleCode", request.ruleCode);
            request.ruleCode = null;
        }
        if (request.ruleName != null) {
            ctReq.addParam("ruleName", request.ruleName);
            request.ruleName = null;
        }
        ctReq.writeString("", template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ListCollectRuleResponse.class);
    }

    public static class ListCollectRuleRequest {
        /** 资源池编码，请参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 单元ID，可从单元列表获取 */
        @JsonProperty("unitCode")
        private String unitCode;

        /** 采集规则编码，可从采集规则列表获取 */
        @JsonProperty("ruleCode")
        private String ruleCode;

        /** 可根据采集规则名称和原始名称模糊匹配 */
        @JsonProperty("ruleName")
        private String ruleName;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getUnitCode() {
            return this.unitCode;
        }

        public void setUnitCode(String unitCode) {
            this.unitCode = unitCode;
        }

        public String getRuleCode() {
            return this.ruleCode;
        }

        public void setRuleCode(String ruleCode) {
            this.ruleCode = ruleCode;
        }

        public String getRuleName() {
            return this.ruleName;
        }

        public void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }
    }

    public static class ListCollectRuleResponse {
        /** 响应状态码。0：代表正常；-1：代表严重错误；-2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 规则列表 */
        @JsonProperty("returnObj")
        private ListCollectRuleReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public ListCollectRuleReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ListCollectRuleReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ListCollectRuleReturnObjResponse {
        /** 采集规则编码 */
        @JsonProperty("ruleCode")
        private String ruleCode;

        /** 单元ID */
        @JsonProperty("unitCode")
        private String unitCode;

        /** 采集规则原始名称 */
        @JsonProperty("ruleName")
        private String ruleName;

        /** 采集类型，1： 云主机-文本日志；2：云容器引擎-标准输出；3：云容器引擎-文本日志；4：syslog-协议; 5: 物理机-文本日志 */
        @JsonProperty("extractMode")
        private Byte extractMode;

        /** 切割模式，不同模式对应其他参数不同。1：单行正则；2：分隔符；3：多行正则；4：单行全文；5：json；6：多行全文 */
        @JsonProperty("cuttingMode")
        private String cuttingMode;

        /** 规则属性 */
        @JsonProperty("ruleConfig")
        private ListCollectRuleReturnObjRuleConfigResponse ruleConfig;

        public String getRuleCode() {
            return this.ruleCode;
        }

        public void setRuleCode(String ruleCode) {
            this.ruleCode = ruleCode;
        }

        public String getUnitCode() {
            return this.unitCode;
        }

        public void setUnitCode(String unitCode) {
            this.unitCode = unitCode;
        }

        public String getRuleName() {
            return this.ruleName;
        }

        public void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public Byte getExtractMode() {
            return this.extractMode;
        }

        public void setExtractMode(Byte extractMode) {
            this.extractMode = extractMode;
        }

        public String getCuttingMode() {
            return this.cuttingMode;
        }

        public void setCuttingMode(String cuttingMode) {
            this.cuttingMode = cuttingMode;
        }

        public ListCollectRuleReturnObjRuleConfigResponse getRuleConfig() {
            return this.ruleConfig;
        }

        public void setRuleConfig(ListCollectRuleReturnObjRuleConfigResponse ruleConfig) {
            this.ruleConfig = ruleConfig;
        }
    }

    public static class ListCollectRuleReturnObjRuleConfigResponse {
        /** 当采集路径中带"**"通配符时，该参数用于指定"**"通配符最大解析深度 */
        @JsonProperty("maxPathDepth")
        private Integer maxPathDepth;

        /** 正则切割模式，当切割模式为正则时返回 */
        @JsonProperty("regex")
        private ListCollectRuleReturnObjRuleConfigRegexResponse regex;

        /** 分隔符，当切割模式为分隔符时必填 */
        @JsonProperty("delimiter")
        private ListCollectRuleReturnObjRuleConfigDelimiterResponse delimiter;

        public Integer getMaxPathDepth() {
            return this.maxPathDepth;
        }

        public void setMaxPathDepth(Integer maxPathDepth) {
            this.maxPathDepth = maxPathDepth;
        }

        public ListCollectRuleReturnObjRuleConfigRegexResponse getRegex() {
            return this.regex;
        }

        public void setRegex(ListCollectRuleReturnObjRuleConfigRegexResponse regex) {
            this.regex = regex;
        }

        public ListCollectRuleReturnObjRuleConfigDelimiterResponse getDelimiter() {
            return this.delimiter;
        }

        public void setDelimiter(ListCollectRuleReturnObjRuleConfigDelimiterResponse delimiter) {
            this.delimiter = delimiter;
        }
    }

    public static class ListCollectRuleReturnObjRuleConfigRegexResponse {
        /** 分隔符 */
        @JsonProperty("delimiter")
        private String delimiter;

        /** 分割所得类型字段 */
        @JsonProperty("logContent")
        private List<ListCollectRuleReturnObjRuleConfigRegexLogContentResponse> logContent;

        public String getDelimiter() {
            return this.delimiter;
        }

        public void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        public List<ListCollectRuleReturnObjRuleConfigRegexLogContentResponse> getLogContent() {
            return this.logContent;
        }

        public void setLogContent(
                List<ListCollectRuleReturnObjRuleConfigRegexLogContentResponse> logContent) {
            this.logContent = logContent;
        }
    }

    public static class ListCollectRuleReturnObjRuleConfigDelimiterResponse {
        /** 正则表达式 */
        @JsonProperty("regexStr")
        private String regexStr;

        /** 正则分词所得类型字段 */
        @JsonProperty("logContent")
        private List<ListCollectRuleReturnObjRuleConfigDelimiterLogContentResponse> logContent;

        public String getRegexStr() {
            return this.regexStr;
        }

        public void setRegexStr(String regexStr) {
            this.regexStr = regexStr;
        }

        public List<ListCollectRuleReturnObjRuleConfigDelimiterLogContentResponse> getLogContent() {
            return this.logContent;
        }

        public void setLogContent(
                List<ListCollectRuleReturnObjRuleConfigDelimiterLogContentResponse> logContent) {
            this.logContent = logContent;
        }
    }

    public static class ListCollectRuleReturnObjRuleConfigRegexLogContentResponse {
        /** 提取字段 */
        @JsonProperty("key")
        private String key;

        /** 数据类型。text：字符串；double：数字 */
        @JsonProperty("type")
        private String type;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    public static class ListCollectRuleReturnObjRuleConfigDelimiterLogContentResponse {
        /** 数据类型。text：字符串；double：数字 */
        @JsonProperty("type")
        private String type;

        /** 提取字段 */
        @JsonProperty("key")
        private String key;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }
    }
}
