package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 告警规则分页列表 */
public class CtltsListAlertRuleApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsListAlertRuleApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(ENDPOINT_NAME, "GET", "/v1/alert/rule/list", "text/plain");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ListAlertRuleResponse send(Credential credential, ListAlertRuleRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.projectCode != null) {
            ctReq.addParam("projectCode", request.projectCode);
            request.projectCode = null;
        }
        if (request.unitCode != null) {
            ctReq.addParam("unitCode", request.unitCode);
            request.unitCode = null;
        }
        if (request.ruleName != null) {
            ctReq.addParam("ruleName", request.ruleName);
            request.ruleName = null;
        }
        if (request.pageNum != null) {
            ctReq.addParam("pageNum", String.valueOf(request.pageNum));
            request.pageNum = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        ctReq.writeString("", template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ListAlertRuleResponse.class);
    }

    public static class ListAlertRuleRequest {
        /** 资源池编码，请参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 日志项目ID（projectCode、unitCode、ruleName 必传至少一个参数）。日志项目列表接口会返回日志项目ID */
        @JsonProperty("projectCode")
        private String projectCode;

        /** 日志单元ID（projectCode、unitCode、ruleName 必传至少一个参数）。日志单元列表接口会返回日志单元ID */
        @JsonProperty("unitCode")
        private String unitCode;

        /** 告警规则名称（projectCode、unitCode、ruleName 必传至少一个参数） */
        @JsonProperty("ruleName")
        private String ruleName;

        /** 页码，默认1 */
        @JsonProperty("pageNum")
        private Integer pageNum;

        /** 每页大小，默认10 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProjectCode() {
            return this.projectCode;
        }

        public void setProjectCode(String projectCode) {
            this.projectCode = projectCode;
        }

        public String getUnitCode() {
            return this.unitCode;
        }

        public void setUnitCode(String unitCode) {
            this.unitCode = unitCode;
        }

        public String getRuleName() {
            return this.ruleName;
        }

        public void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public Integer getPageNum() {
            return this.pageNum;
        }

        public void setPageNum(Integer pageNum) {
            this.pageNum = pageNum;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class ListAlertRuleResponse {
        /** 响应状态码。0：代表正常；-1：代表严重错误；-2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 分页响应对象 */
        @JsonProperty("returnObj")
        private ListAlertRuleReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public ListAlertRuleReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ListAlertRuleReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ListAlertRuleReturnObjResponse {
        /** 总记录数 */
        @JsonProperty("total")
        private Long total;

        /** 数据列表 */
        @JsonProperty("list")
        private List<ListAlertRuleReturnObjListResponse> list;

        public Long getTotal() {
            return this.total;
        }

        public void setTotal(Long total) {
            this.total = total;
        }

        public List<ListAlertRuleReturnObjListResponse> getList() {
            return this.list;
        }

        public void setList(List<ListAlertRuleReturnObjListResponse> list) {
            this.list = list;
        }
    }

    public static class ListAlertRuleReturnObjListResponse {
        /** 告警规则编码 */
        @JsonProperty("ruleCode")
        private String ruleCode;

        /** 告警规则名称，长度在1-50个字符范围内 */
        @JsonProperty("ruleName")
        private String ruleName;

        /** 日志项目编码 */
        @JsonProperty("projectCode")
        private String projectCode;

        /** 日志单元编码 */
        @JsonProperty("unitCode")
        private String unitCode;

        /** 检查频率，1：固定频率；2：固定时间 */
        @JsonProperty("queryMode")
        private Byte queryMode;

        /** 固定频率间隔 */
        @JsonProperty("queryDuration")
        private Integer queryDuration;

        /** 固定频率间隔时间单位，1：分钟；2：小时；3：天 */
        @JsonProperty("queryDurationUnit")
        private Byte queryDurationUnit;

        /** 固定时间，格式：HH:MM */
        @JsonProperty("queryTime")
        private String queryTime;

        /** 通知策略ID */
        @JsonProperty("notifyStrategyId")
        private Long notifyStrategyId;

        /** 告警通知模板 */
        @JsonProperty("alertMessageTemplate")
        private String alertMessageTemplate;

        /** 告警规则启用状态，0：已启用； 1：启用中； 2：停用中； 3：失败； 4：停用 */
        @JsonProperty("ruleStatus")
        private Byte ruleStatus;

        /** 检索条件 */
        @JsonProperty("logSearch")
        private ListAlertRuleReturnObjListLogSearchResponse logSearch;

        /** 触发条件 */
        @JsonProperty("triggerConds")
        private List<ListAlertRuleReturnObjListTriggerCondsResponse> triggerConds;

        /** 启用状态名称 */
        @JsonProperty("ruleStatusName")
        private String ruleStatusName;

        public String getRuleCode() {
            return this.ruleCode;
        }

        public void setRuleCode(String ruleCode) {
            this.ruleCode = ruleCode;
        }

        public String getRuleName() {
            return this.ruleName;
        }

        public void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public String getProjectCode() {
            return this.projectCode;
        }

        public void setProjectCode(String projectCode) {
            this.projectCode = projectCode;
        }

        public String getUnitCode() {
            return this.unitCode;
        }

        public void setUnitCode(String unitCode) {
            this.unitCode = unitCode;
        }

        public Byte getQueryMode() {
            return this.queryMode;
        }

        public void setQueryMode(Byte queryMode) {
            this.queryMode = queryMode;
        }

        public Integer getQueryDuration() {
            return this.queryDuration;
        }

        public void setQueryDuration(Integer queryDuration) {
            this.queryDuration = queryDuration;
        }

        public Byte getQueryDurationUnit() {
            return this.queryDurationUnit;
        }

        public void setQueryDurationUnit(Byte queryDurationUnit) {
            this.queryDurationUnit = queryDurationUnit;
        }

        public String getQueryTime() {
            return this.queryTime;
        }

        public void setQueryTime(String queryTime) {
            this.queryTime = queryTime;
        }

        public Long getNotifyStrategyId() {
            return this.notifyStrategyId;
        }

        public void setNotifyStrategyId(Long notifyStrategyId) {
            this.notifyStrategyId = notifyStrategyId;
        }

        public String getAlertMessageTemplate() {
            return this.alertMessageTemplate;
        }

        public void setAlertMessageTemplate(String alertMessageTemplate) {
            this.alertMessageTemplate = alertMessageTemplate;
        }

        public Byte getRuleStatus() {
            return this.ruleStatus;
        }

        public void setRuleStatus(Byte ruleStatus) {
            this.ruleStatus = ruleStatus;
        }

        public ListAlertRuleReturnObjListLogSearchResponse getLogSearch() {
            return this.logSearch;
        }

        public void setLogSearch(ListAlertRuleReturnObjListLogSearchResponse logSearch) {
            this.logSearch = logSearch;
        }

        public List<ListAlertRuleReturnObjListTriggerCondsResponse> getTriggerConds() {
            return this.triggerConds;
        }

        public void setTriggerConds(
                List<ListAlertRuleReturnObjListTriggerCondsResponse> triggerConds) {
            this.triggerConds = triggerConds;
        }

        public String getRuleStatusName() {
            return this.ruleStatusName;
        }

        public void setRuleStatusName(String ruleStatusName) {
            this.ruleStatusName = ruleStatusName;
        }
    }

    public static class ListAlertRuleReturnObjListLogSearchResponse {
        /** 日志项目ID。日志项目列表接口会返回日志项目ID */
        @JsonProperty("projectCode")
        private String projectCode;

        /** 日志单元ID。日志单元列表接口会返回日志单元ID */
        @JsonProperty("unitCode")
        private String unitCode;

        /** 检索时间范围，填写整数值，最长不超过1天 */
        @JsonProperty("searchDuration")
        private Integer searchDuration;

        /** 检索时间单位，1：分钟；2：小时；3：天 */
        @JsonProperty("searchDurationUnit")
        private Byte searchDurationUnit;

        /** 检索分析SQL */
        @JsonProperty("querySql")
        private String querySql;

        public String getProjectCode() {
            return this.projectCode;
        }

        public void setProjectCode(String projectCode) {
            this.projectCode = projectCode;
        }

        public String getUnitCode() {
            return this.unitCode;
        }

        public void setUnitCode(String unitCode) {
            this.unitCode = unitCode;
        }

        public Integer getSearchDuration() {
            return this.searchDuration;
        }

        public void setSearchDuration(Integer searchDuration) {
            this.searchDuration = searchDuration;
        }

        public Byte getSearchDurationUnit() {
            return this.searchDurationUnit;
        }

        public void setSearchDurationUnit(Byte searchDurationUnit) {
            this.searchDurationUnit = searchDurationUnit;
        }

        public String getQuerySql() {
            return this.querySql;
        }

        public void setQuerySql(String querySql) {
            this.querySql = querySql;
        }
    }

    public static class ListAlertRuleReturnObjListTriggerCondsResponse {
        /** 触发模式，1：有数据；2：有特定条数据；3：有数据匹配；4：有特定条数据匹配 */
        @JsonProperty("triggerModel")
        private Byte triggerModel;

        /** 比较值：>，<，>=，<=，= （当 triggerModel 为 2 或 4 时，必填） */
        @JsonProperty("compare")
        private String compare;

        /** 告警阈值（当 triggerModel 为 2 或 4 时，必填） */
        @JsonProperty("value")
        private Long value;

        /** 条件表达式（当 triggerModel 为 3 或 4 时，必填） */
        @JsonProperty("evalCondition")
        private String evalCondition;

        /** 告警等级取值范围，1：一般；2：次要；3：重要；4：紧急 */
        @JsonProperty("alertLevel")
        private Byte alertLevel;

        public Byte getTriggerModel() {
            return this.triggerModel;
        }

        public void setTriggerModel(Byte triggerModel) {
            this.triggerModel = triggerModel;
        }

        public String getCompare() {
            return this.compare;
        }

        public void setCompare(String compare) {
            this.compare = compare;
        }

        public Long getValue() {
            return this.value;
        }

        public void setValue(Long value) {
            this.value = value;
        }

        public String getEvalCondition() {
            return this.evalCondition;
        }

        public void setEvalCondition(String evalCondition) {
            this.evalCondition = evalCondition;
        }

        public Byte getAlertLevel() {
            return this.alertLevel;
        }

        public void setAlertLevel(Byte alertLevel) {
            this.alertLevel = alertLevel;
        }
    }
}
