package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 获取已绑定指定采集规则的主机组组列表 */
public class CtltsHostGroupListByRuleIdApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsHostGroupListByRuleIdApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v1/hostGroup/collectRule/hostGroups", "text/plain");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public HostGroupListByRuleIdResponse send(
            Credential credential, HostGroupListByRuleIdRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.ruleCode != null) {
            ctReq.addParam("ruleCode", request.ruleCode);
            request.ruleCode = null;
        }
        ctReq.writeString("", template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(HostGroupListByRuleIdResponse.class);
    }

    public static class HostGroupListByRuleIdRequest {
        /** 资源池编码，请参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 采集规则编码，创建采集规则接口会返回采集规则编码，方便后续查找。 */
        @JsonProperty("ruleCode")
        private String ruleCode;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getRuleCode() {
            return this.ruleCode;
        }

        public void setRuleCode(String ruleCode) {
            this.ruleCode = ruleCode;
        }
    }

    public static class HostGroupListByRuleIdResponse {
        /** 响应状态码。0：代表正常； -1：代表严重错误； -2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应结果 */
        @JsonProperty("returnObj")
        private List<HostGroupListByRuleIdReturnObjResponse> returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public List<HostGroupListByRuleIdReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<HostGroupListByRuleIdReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class HostGroupListByRuleIdReturnObjResponse {
        /** 主机组编码 */
        @JsonProperty("hostGroupCode")
        private String hostGroupCode;

        /** 主机组名称 */
        @JsonProperty("hostGroupName")
        private String hostGroupName;

        /** 描述 */
        @JsonProperty("description")
        private String description;

        /**
         * 主机组类型，支持uuid和sign（自定义标识），可参考<a
         * href="https://www.ctyun.cn/document/10261471/10977630">主机组管理</a>
         */
        @JsonProperty("hostIdentityType")
        private String hostIdentityType;

        public String getHostGroupCode() {
            return this.hostGroupCode;
        }

        public void setHostGroupCode(String hostGroupCode) {
            this.hostGroupCode = hostGroupCode;
        }

        public String getHostGroupName() {
            return this.hostGroupName;
        }

        public void setHostGroupName(String hostGroupName) {
            this.hostGroupName = hostGroupName;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getHostIdentityType() {
            return this.hostIdentityType;
        }

        public void setHostIdentityType(String hostIdentityType) {
            this.hostIdentityType = hostIdentityType;
        }
    }
}
