package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 获取单元用量 */
public class CtltsGetUnitUsageApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsGetUnitUsageApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/v1/usage/getUnitUsage", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetUnitUsageResponse send(Credential credential, GetUnitUsageRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetUnitUsageResponse.class);
    }

    public static class GetUnitUsageRequest {
        /** 资源池编码，请参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 页码数，不传默认为1 */
        @JsonProperty("pageNum")
        private Integer pageNum;

        /** 每页展示数据量，不传默认为10 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 起始时间，单位毫秒 */
        @JsonProperty("startTime")
        private Long startTime;

        /** 截止时间，单位毫秒 */
        @JsonProperty("endTime")
        private Long endTime;

        /** 存储用量排序， 传值：desc；asc */
        @JsonProperty("storageOrder")
        private String storageOrder;

        /** 冷存储用量排序，传值：desc；asc */
        @JsonProperty("coldStorageOrder")
        private String coldStorageOrder;

        /** 读写用量排序，传值：desc；asc */
        @JsonProperty("readWriteOrder")
        private String readWriteOrder;

        /** 加工用量排序，传值：desc；asc */
        @JsonProperty("processFlowOrder")
        private String processFlowOrder;

        /** 投递oss用量排序，传值：desc；asc */
        @JsonProperty("deliverOssOrder")
        private String deliverOssOrder;

        /** 索引流量排序，传值：desc；asc */
        @JsonProperty("indexOrder")
        private String indexOrder;

        /** 项目ID，可从项目列表接口获取 */
        @JsonProperty("projectCode")
        private String projectCode;

        /** 单元ID，可从单元列表接口获取 */
        @JsonProperty("unitCode")
        private String unitCode;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public Integer getPageNum() {
            return this.pageNum;
        }

        public void setPageNum(Integer pageNum) {
            this.pageNum = pageNum;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public Long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public Long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        public String getStorageOrder() {
            return this.storageOrder;
        }

        public void setStorageOrder(String storageOrder) {
            this.storageOrder = storageOrder;
        }

        public String getColdStorageOrder() {
            return this.coldStorageOrder;
        }

        public void setColdStorageOrder(String coldStorageOrder) {
            this.coldStorageOrder = coldStorageOrder;
        }

        public String getReadWriteOrder() {
            return this.readWriteOrder;
        }

        public void setReadWriteOrder(String readWriteOrder) {
            this.readWriteOrder = readWriteOrder;
        }

        public String getProcessFlowOrder() {
            return this.processFlowOrder;
        }

        public void setProcessFlowOrder(String processFlowOrder) {
            this.processFlowOrder = processFlowOrder;
        }

        public String getDeliverOssOrder() {
            return this.deliverOssOrder;
        }

        public void setDeliverOssOrder(String deliverOssOrder) {
            this.deliverOssOrder = deliverOssOrder;
        }

        public String getIndexOrder() {
            return this.indexOrder;
        }

        public void setIndexOrder(String indexOrder) {
            this.indexOrder = indexOrder;
        }

        public String getProjectCode() {
            return this.projectCode;
        }

        public void setProjectCode(String projectCode) {
            this.projectCode = projectCode;
        }

        public String getUnitCode() {
            return this.unitCode;
        }

        public void setUnitCode(String unitCode) {
            this.unitCode = unitCode;
        }
    }

    public static class GetUnitUsageResponse {
        /** 响应状态码。0：代表正常；-1：代表严重错误；-2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 分页响应对象 */
        @JsonProperty("returnObj")
        private GetUnitUsageReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetUnitUsageReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetUnitUsageReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class GetUnitUsageReturnObjResponse {
        /** 总记录数 */
        @JsonProperty("total")
        private Long total;

        /** 数据列表 */
        @JsonProperty("list")
        private List<GetUnitUsageReturnObjListResponse> list;

        public Long getTotal() {
            return this.total;
        }

        public void setTotal(Long total) {
            this.total = total;
        }

        public List<GetUnitUsageReturnObjListResponse> getList() {
            return this.list;
        }

        public void setList(List<GetUnitUsageReturnObjListResponse> list) {
            this.list = list;
        }
    }

    public static class GetUnitUsageReturnObjListResponse {
        /** 单元ID */
        @JsonProperty("unitCode")
        private String unitCode;

        /** 单元名称 */
        @JsonProperty("unitName")
        private String unitName;

        /** 项目ID */
        @JsonProperty("projectCode")
        private String projectCode;

        /** 读写用量，单位GB */
        @JsonProperty("networkIOUsageTotal")
        private Double networkIOUsageTotal;

        /** 存储用量，单位GB */
        @JsonProperty("storageUsageTotal")
        private Double storageUsageTotal;

        /** 冷存储用量，单位GB */
        @JsonProperty("coldStorageUsageTotal")
        private Double coldStorageUsageTotal;

        /** 加工用量，单位GB */
        @JsonProperty("processFlowTotal")
        private Double processFlowTotal;

        /** 投递用量，单位GB */
        @JsonProperty("deliverOssTotal")
        private Double deliverOssTotal;

        /** 索引用量，单位GB */
        @JsonProperty("indexUsageTotal")
        private Double indexUsageTotal;

        public String getUnitCode() {
            return this.unitCode;
        }

        public void setUnitCode(String unitCode) {
            this.unitCode = unitCode;
        }

        public String getUnitName() {
            return this.unitName;
        }

        public void setUnitName(String unitName) {
            this.unitName = unitName;
        }

        public String getProjectCode() {
            return this.projectCode;
        }

        public void setProjectCode(String projectCode) {
            this.projectCode = projectCode;
        }

        public Double getNetworkIOUsageTotal() {
            return this.networkIOUsageTotal;
        }

        public void setNetworkIOUsageTotal(Double networkIOUsageTotal) {
            this.networkIOUsageTotal = networkIOUsageTotal;
        }

        public Double getStorageUsageTotal() {
            return this.storageUsageTotal;
        }

        public void setStorageUsageTotal(Double storageUsageTotal) {
            this.storageUsageTotal = storageUsageTotal;
        }

        public Double getColdStorageUsageTotal() {
            return this.coldStorageUsageTotal;
        }

        public void setColdStorageUsageTotal(Double coldStorageUsageTotal) {
            this.coldStorageUsageTotal = coldStorageUsageTotal;
        }

        public Double getProcessFlowTotal() {
            return this.processFlowTotal;
        }

        public void setProcessFlowTotal(Double processFlowTotal) {
            this.processFlowTotal = processFlowTotal;
        }

        public Double getDeliverOssTotal() {
            return this.deliverOssTotal;
        }

        public void setDeliverOssTotal(Double deliverOssTotal) {
            this.deliverOssTotal = deliverOssTotal;
        }

        public Double getIndexUsageTotal() {
            return this.indexUsageTotal;
        }

        public void setIndexUsageTotal(Double indexUsageTotal) {
            this.indexUsageTotal = indexUsageTotal;
        }
    }
}
