package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;
import java.util.Map;

/** 根据采集配置名称获取采集配置 */
public class CtltsGetRuleConfigApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsGetRuleConfigApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v1/collectorRule/getRuleConfigByName",
                        "text/plain");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetRuleConfigResponse send(Credential credential, GetRuleConfigRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.ruleName != null) {
            ctReq.addParam("ruleName", request.ruleName);
            request.ruleName = null;
        }
        if (request.unitCode != null) {
            ctReq.addParam("unitCode", request.unitCode);
            request.unitCode = null;
        }
        ctReq.writeString("", template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetRuleConfigResponse.class);
    }

    public static class GetRuleConfigRequest {
        /** 资源池编码，请参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 可根据采集规则名称和原始名称模糊匹配 */
        @JsonProperty("ruleName")
        private String ruleName;

        /** 日志单元ID */
        @JsonProperty("unitCode")
        private String unitCode;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getRuleName() {
            return this.ruleName;
        }

        public void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public String getUnitCode() {
            return this.unitCode;
        }

        public void setUnitCode(String unitCode) {
            this.unitCode = unitCode;
        }
    }

    public static class GetRuleConfigResponse {
        /** 响应状态码。0：代表正常； -1：代表严重错误； -2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求响应数据体 */
        @JsonProperty("returnObj")
        private GetRuleConfigReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public GetRuleConfigReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetRuleConfigReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class GetRuleConfigReturnObjResponse {
        /** 规则是否启用。true：启用；false：停用 */
        @JsonProperty("enable")
        private Boolean enable;

        /** 日志单元ID */
        @JsonProperty("unitCode")
        private String unitCode;

        /** 规则原始名称，不允许修改 */
        @JsonProperty("ruleName")
        private String ruleName;

        /** 采集规则名称，允许修改 */
        @JsonProperty("ruleAliasName")
        private String ruleAliasName;

        /** 采集规则ID */
        @JsonProperty("ruleCode")
        private String ruleCode;

        /**
         * 采集类型。1：云主机-文本日志；2：云容器引擎-标准输出；3：云容器引擎-文本日志；4：syslog-协议；5：物理机-文本日志；6：windows事件日志；7：对象存储文件；8：Kafka数据导入；9：Systemd
         * Journal日志；10：审计日志；11：k8s节点文件日志
         */
        @JsonProperty("extractMode")
        private Byte extractMode;

        /**
         * 待采集的日志文件路径列表（目前仅限1个路径）。路径中支持使用*和**通配符，其中**通配符仅能出现一次且仅限用于文件名前。说明：当extractMode=2时，该参数不用填。
         */
        @JsonProperty("logPaths")
        private List<String> logPaths;

        /** 提取模式，不同模式对应其他参数不同。1：单行正则；2：分隔符；3：多行正则；4：单行全文；5：json；6：多行全文；7：组合解析；8：nginx模板解析 */
        @JsonProperty("cuttingMode")
        private Byte cuttingMode;

        /**
         * 接入类型。1：ccse；2：msap；3：csm；4：faas；5：msegw；6：ctgcache；7：kafka；8：mq2；9：amqp；10：host；11：mqtt；12：ebm；13：
         * rcc；14：oss_import；15：kafka_data；16：audit_import；17：cce_one；18：cae
         */
        @JsonProperty("accessType")
        private Byte accessType;

        /** 创建时间 */
        @JsonProperty("createTime")
        private String createTime;

        /** 规则配置对象 */
        @JsonProperty("ruleConfig")
        private GetRuleConfigReturnObjRuleConfigResponse ruleConfig;

        public Boolean getEnable() {
            return this.enable;
        }

        public void setEnable(Boolean enable) {
            this.enable = enable;
        }

        public String getUnitCode() {
            return this.unitCode;
        }

        public void setUnitCode(String unitCode) {
            this.unitCode = unitCode;
        }

        public String getRuleName() {
            return this.ruleName;
        }

        public void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public String getRuleAliasName() {
            return this.ruleAliasName;
        }

        public void setRuleAliasName(String ruleAliasName) {
            this.ruleAliasName = ruleAliasName;
        }

        public String getRuleCode() {
            return this.ruleCode;
        }

        public void setRuleCode(String ruleCode) {
            this.ruleCode = ruleCode;
        }

        public Byte getExtractMode() {
            return this.extractMode;
        }

        public void setExtractMode(Byte extractMode) {
            this.extractMode = extractMode;
        }

        public List<String> getLogPaths() {
            return this.logPaths;
        }

        public void setLogPaths(List<String> logPaths) {
            this.logPaths = logPaths;
        }

        public Byte getCuttingMode() {
            return this.cuttingMode;
        }

        public void setCuttingMode(Byte cuttingMode) {
            this.cuttingMode = cuttingMode;
        }

        public Byte getAccessType() {
            return this.accessType;
        }

        public void setAccessType(Byte accessType) {
            this.accessType = accessType;
        }

        public String getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        public GetRuleConfigReturnObjRuleConfigResponse getRuleConfig() {
            return this.ruleConfig;
        }

        public void setRuleConfig(GetRuleConfigReturnObjRuleConfigResponse ruleConfig) {
            this.ruleConfig = ruleConfig;
        }
    }

    public static class GetRuleConfigReturnObjRuleConfigResponse {
        /** 文件路径黑名单 */
        @JsonProperty("excludeFilePaths")
        private List<String> excludeFilePaths;

        /** 文件黑名单 */
        @JsonProperty("excludeFiles")
        private List<String> excludeFiles;

        /** 目录黑名单 */
        @JsonProperty("excludeDirs")
        private List<String> excludeDirs;

        /** 当采集路径中带"**"通配符时，该参数用于指定"**"通配符最大解析深度 */
        @JsonProperty("maxPathDepth")
        private Integer maxPathDepth;

        /** 文件编码，取值为UTF8和GBK */
        @JsonProperty("fileEncoding")
        private String fileEncoding;

        /** 分隔符，当切割模式为分隔符时必填 */
        @JsonProperty("delimiter")
        private GetRuleConfigReturnObjRuleConfigDelimiterResponse delimiter;

        /** 正则切割模式，当切割模式为正则时需要 */
        @JsonProperty("regex")
        private GetRuleConfigReturnObjRuleConfigRegexResponse regex;

        /** nginx分词模板接入配置对象 */
        @JsonProperty("nginxTemplate")
        private GetRuleConfigReturnObjRuleConfigNginxTemplateResponse nginxTemplate;

        /**
         * 设置K8S
         * Label日志标签后，lts将在日志中新增相关字段。例如设置LabelKey为app，设置LabelValue为app_alias，当容器中包含app=lts时，将在日志中添加内容{app_alias：lts}。
         */
        @JsonProperty("dynamicK8sLabels")
        private Map dynamicK8sLabels;

        /**
         * 设置环境变量日志标签后，lts将在日志中新增相关字段，例如设置环境变量Key为app，设置环境变量Value为app_alias，当K8S中包含环境变量app=lts时，将在日志中添加的内容为{app_alias：lts}。
         */
        @JsonProperty("dynamicK8sEnv")
        private String dynamicK8sEnv;

        /** 容器场景下，配置容器过滤等配置 */
        @JsonProperty("containers")
        private GetRuleConfigReturnObjRuleConfigContainersResponse containers;

        /**
         * 日志主题类型。none: 无，如果定义了类型，但是TopicFormat格式错误，会忽略日志主题，使用none；filepath:
         * 从日志采集路径里正则匹配提取；custom：自定义，TopicFormat为定义的值
         */
        @JsonProperty("topicType")
        private String topicType;

        /** 当TopicType为filepath，需定义为日志路径提取的正则表达式； 当TopicType为custom，则允许自定义字符串。 */
        @JsonProperty("topicFormat")
        private String topicFormat;

        /** 是否开启标准输出，默认true */
        @JsonProperty("enableStdout")
        private Boolean enableStdout;

        /** 是否开启标准错误，默认true */
        @JsonProperty("enableStderr")
        private Boolean enableStderr;

        /** 回采日志大小，单位KB；最小值为0，最大值为10485760 */
        @JsonProperty("tailSize")
        private String tailSize;

        /** 解析失败是否保留日志原文，默认true */
        @JsonProperty("keepSourceWhenParseFail")
        private Boolean keepSourceWhenParseFail;

        /** 解析成功时是否保留源字段，默认true */
        @JsonProperty("keepSourceWhenParseSucceed")
        private String keepSourceWhenParseSucceed;

        /** 日志过滤信息 */
        @JsonProperty("logFilterVo")
        private GetRuleConfigReturnObjRuleConfigLogFilterVoResponse logFilterVo;

        public List<String> getExcludeFilePaths() {
            return this.excludeFilePaths;
        }

        public void setExcludeFilePaths(List<String> excludeFilePaths) {
            this.excludeFilePaths = excludeFilePaths;
        }

        public List<String> getExcludeFiles() {
            return this.excludeFiles;
        }

        public void setExcludeFiles(List<String> excludeFiles) {
            this.excludeFiles = excludeFiles;
        }

        public List<String> getExcludeDirs() {
            return this.excludeDirs;
        }

        public void setExcludeDirs(List<String> excludeDirs) {
            this.excludeDirs = excludeDirs;
        }

        public Integer getMaxPathDepth() {
            return this.maxPathDepth;
        }

        public void setMaxPathDepth(Integer maxPathDepth) {
            this.maxPathDepth = maxPathDepth;
        }

        public String getFileEncoding() {
            return this.fileEncoding;
        }

        public void setFileEncoding(String fileEncoding) {
            this.fileEncoding = fileEncoding;
        }

        public GetRuleConfigReturnObjRuleConfigDelimiterResponse getDelimiter() {
            return this.delimiter;
        }

        public void setDelimiter(GetRuleConfigReturnObjRuleConfigDelimiterResponse delimiter) {
            this.delimiter = delimiter;
        }

        public GetRuleConfigReturnObjRuleConfigRegexResponse getRegex() {
            return this.regex;
        }

        public void setRegex(GetRuleConfigReturnObjRuleConfigRegexResponse regex) {
            this.regex = regex;
        }

        public GetRuleConfigReturnObjRuleConfigNginxTemplateResponse getNginxTemplate() {
            return this.nginxTemplate;
        }

        public void setNginxTemplate(
                GetRuleConfigReturnObjRuleConfigNginxTemplateResponse nginxTemplate) {
            this.nginxTemplate = nginxTemplate;
        }

        public Map getDynamicK8sLabels() {
            return this.dynamicK8sLabels;
        }

        public void setDynamicK8sLabels(Map dynamicK8sLabels) {
            this.dynamicK8sLabels = dynamicK8sLabels;
        }

        public String getDynamicK8sEnv() {
            return this.dynamicK8sEnv;
        }

        public void setDynamicK8sEnv(String dynamicK8sEnv) {
            this.dynamicK8sEnv = dynamicK8sEnv;
        }

        public GetRuleConfigReturnObjRuleConfigContainersResponse getContainers() {
            return this.containers;
        }

        public void setContainers(GetRuleConfigReturnObjRuleConfigContainersResponse containers) {
            this.containers = containers;
        }

        public String getTopicType() {
            return this.topicType;
        }

        public void setTopicType(String topicType) {
            this.topicType = topicType;
        }

        public String getTopicFormat() {
            return this.topicFormat;
        }

        public void setTopicFormat(String topicFormat) {
            this.topicFormat = topicFormat;
        }

        public Boolean getEnableStdout() {
            return this.enableStdout;
        }

        public void setEnableStdout(Boolean enableStdout) {
            this.enableStdout = enableStdout;
        }

        public Boolean getEnableStderr() {
            return this.enableStderr;
        }

        public void setEnableStderr(Boolean enableStderr) {
            this.enableStderr = enableStderr;
        }

        public String getTailSize() {
            return this.tailSize;
        }

        public void setTailSize(String tailSize) {
            this.tailSize = tailSize;
        }

        public Boolean getKeepSourceWhenParseFail() {
            return this.keepSourceWhenParseFail;
        }

        public void setKeepSourceWhenParseFail(Boolean keepSourceWhenParseFail) {
            this.keepSourceWhenParseFail = keepSourceWhenParseFail;
        }

        public String getKeepSourceWhenParseSucceed() {
            return this.keepSourceWhenParseSucceed;
        }

        public void setKeepSourceWhenParseSucceed(String keepSourceWhenParseSucceed) {
            this.keepSourceWhenParseSucceed = keepSourceWhenParseSucceed;
        }

        public GetRuleConfigReturnObjRuleConfigLogFilterVoResponse getLogFilterVo() {
            return this.logFilterVo;
        }

        public void setLogFilterVo(
                GetRuleConfigReturnObjRuleConfigLogFilterVoResponse logFilterVo) {
            this.logFilterVo = logFilterVo;
        }
    }

    public static class GetRuleConfigReturnObjRuleConfigDelimiterResponse {
        /** 分隔符 */
        @JsonProperty("delimiter")
        private String delimiter;

        /** 分割所得类型字段，输入顺序会被使用， */
        @JsonProperty("logContent")
        private List<GetRuleConfigReturnObjRuleConfigDelimiterLogContentResponse> logContent;

        public String getDelimiter() {
            return this.delimiter;
        }

        public void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        public List<GetRuleConfigReturnObjRuleConfigDelimiterLogContentResponse> getLogContent() {
            return this.logContent;
        }

        public void setLogContent(
                List<GetRuleConfigReturnObjRuleConfigDelimiterLogContentResponse> logContent) {
            this.logContent = logContent;
        }
    }

    public static class GetRuleConfigReturnObjRuleConfigRegexResponse {
        /** 提取正则表达式 */
        @JsonProperty("regexStr")
        private String regexStr;

        /** 分割所得类型字段，输入顺序会被使用，正则/多行正则时会被匹配使用 */
        @JsonProperty("logContent")
        private List<GetRuleConfigReturnObjRuleConfigRegexLogContentResponse> logContent;

        public String getRegexStr() {
            return this.regexStr;
        }

        public void setRegexStr(String regexStr) {
            this.regexStr = regexStr;
        }

        public List<GetRuleConfigReturnObjRuleConfigRegexLogContentResponse> getLogContent() {
            return this.logContent;
        }

        public void setLogContent(
                List<GetRuleConfigReturnObjRuleConfigRegexLogContentResponse> logContent) {
            this.logContent = logContent;
        }
    }

    public static class GetRuleConfigReturnObjRuleConfigNginxTemplateResponse {
        /** nginx日志配置 */
        @JsonProperty("nginxLogConf")
        private String nginxLogConf;

        /** 提取正则 */
        @JsonProperty("regexStr")
        private String regexStr;

        /** 日志原文示例 */
        @JsonProperty("eg")
        private String eg;

        /** 日志提取内容。参考 TypeContent */
        @JsonProperty("logContent")
        private List<GetRuleConfigReturnObjRuleConfigNginxTemplateLogContentResponse> logContent;

        public String getNginxLogConf() {
            return this.nginxLogConf;
        }

        public void setNginxLogConf(String nginxLogConf) {
            this.nginxLogConf = nginxLogConf;
        }

        public String getRegexStr() {
            return this.regexStr;
        }

        public void setRegexStr(String regexStr) {
            this.regexStr = regexStr;
        }

        public String getEg() {
            return this.eg;
        }

        public void setEg(String eg) {
            this.eg = eg;
        }

        public List<GetRuleConfigReturnObjRuleConfigNginxTemplateLogContentResponse>
                getLogContent() {
            return this.logContent;
        }

        public void setLogContent(
                List<GetRuleConfigReturnObjRuleConfigNginxTemplateLogContentResponse> logContent) {
            this.logContent = logContent;
        }
    }

    public static class GetRuleConfigReturnObjRuleConfigContainersResponse {
        /**
         * 环境变量黑名单。如果环境变量Value为空，则容器环境变量中包含环境变量Key的容器都将被排除；如果环境变量Value不为空，则容器环境变量中包含环境变量Key=环境变量Value的容器才会被排除；LabelKey需要全匹配，LabelValue支持正则匹配，如果以^开头并且以$结尾，则为正则匹配；多个黑名单之间为或关系，即只要容器的环境变量满足任一键值对即可被排除。
         */
        @JsonProperty("excludeEnv")
        private Map excludeEnv;

        /**
         * Kubernetes Label 黑名单。若LabelValue为空，则K8S Label中包含LabelKey的容器都被排除；若LabelValue不为空，则K8S
         * Label中包含LabelKey=LabelValue的容器才会被排除；LabelKey需要全匹配，LabelValue支持正则匹配，如果以^开头并且以$结尾，则为正则匹配；多个黑名单之间为或关系，即只要K8S
         * Label满足任一黑名单即可被排除。
         */
        @JsonProperty("excludeK8sLabel")
        private Map excludeK8sLabel;

        /**
         * 环境变量白名单。如果环境变量Value为空，则容器环境变量中包含环境变量Key的容器都匹配；如果环境变量Value不为空，则容器环境变量中包含环境变量Key=环境变量Value的容器才被匹配；LabelKey需要全匹配，LabelValue支持正则匹配，如果以^开头并且以$结尾，则为正则匹配；多个白名单之间为或关系，即只要容器的环境变量满足任一键值对即可被匹配。
         */
        @JsonProperty("includeEnv")
        private Map includeEnv;

        /**
         * Kubernetes Label 白名单。若LabelValue为空，则K8S Label中包含LabelKey的容器都匹配；若LabelValue不为空，则K8S
         * Label中包含LabelKey=LabelValue的容器才匹配；LabelKey需要全匹配，LabelValue支持正则匹配，如果以^开头并且以$结尾，则为正则匹配；多个白名单之间为或关系，即只要K8S
         * Label满足任一白名单即可被匹配。
         */
        @JsonProperty("includeK8sLabel")
        private Map includeK8sLabel;

        /** Kubernetes 容器名称正则匹配，仅支持正则匹配。样例：^(container-test)$，匹配所有名为container-test的容器 */
        @JsonProperty("k8sContainerRegex")
        private String k8sContainerRegex;

        /** Kubernetes 命名空间正则匹配，仅支持正则匹配。样例：^(default|nginx)$，表示匹配nginx命名空间或default命名空间下的所有容器 */
        @JsonProperty("k8sNamespaceRegex")
        private String k8sNamespaceRegex;

        /** Kubernetes Pod 名称正则匹配，仅支持正则匹配。样例：^(nginx-log-demo.*)$，匹配以nginx-log-demo开头的Pod下的所有容器 */
        @JsonProperty("k8sPodRegex")
        private String k8sPodRegex;

        public Map getExcludeEnv() {
            return this.excludeEnv;
        }

        public void setExcludeEnv(Map excludeEnv) {
            this.excludeEnv = excludeEnv;
        }

        public Map getExcludeK8sLabel() {
            return this.excludeK8sLabel;
        }

        public void setExcludeK8sLabel(Map excludeK8sLabel) {
            this.excludeK8sLabel = excludeK8sLabel;
        }

        public Map getIncludeEnv() {
            return this.includeEnv;
        }

        public void setIncludeEnv(Map includeEnv) {
            this.includeEnv = includeEnv;
        }

        public Map getIncludeK8sLabel() {
            return this.includeK8sLabel;
        }

        public void setIncludeK8sLabel(Map includeK8sLabel) {
            this.includeK8sLabel = includeK8sLabel;
        }

        public String getK8sContainerRegex() {
            return this.k8sContainerRegex;
        }

        public void setK8sContainerRegex(String k8sContainerRegex) {
            this.k8sContainerRegex = k8sContainerRegex;
        }

        public String getK8sNamespaceRegex() {
            return this.k8sNamespaceRegex;
        }

        public void setK8sNamespaceRegex(String k8sNamespaceRegex) {
            this.k8sNamespaceRegex = k8sNamespaceRegex;
        }

        public String getK8sPodRegex() {
            return this.k8sPodRegex;
        }

        public void setK8sPodRegex(String k8sPodRegex) {
            this.k8sPodRegex = k8sPodRegex;
        }
    }

    public static class GetRuleConfigReturnObjRuleConfigLogFilterVoResponse {
        /** 需要保留kv信息 */
        @JsonProperty("include")
        private Map include;

        /** 需要丢弃的kv信息 */
        @JsonProperty("exclude")
        private Map exclude;

        public Map getInclude() {
            return this.include;
        }

        public void setInclude(Map include) {
            this.include = include;
        }

        public Map getExclude() {
            return this.exclude;
        }

        public void setExclude(Map exclude) {
            this.exclude = exclude;
        }
    }

    public static class GetRuleConfigReturnObjRuleConfigDelimiterLogContentResponse {
        /** 提取字段 */
        @JsonProperty("key")
        private String key;

        /** 数据类型。text：字符串；double：数字 */
        @JsonProperty("type")
        private String type;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    public static class GetRuleConfigReturnObjRuleConfigRegexLogContentResponse {
        /** 提取字段 */
        @JsonProperty("key")
        private String key;

        /** 数据类型。text：字符串；double：数字 */
        @JsonProperty("type")
        private String type;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    public static class GetRuleConfigReturnObjRuleConfigNginxTemplateLogContentResponse {
        /** 提取字段 */
        @JsonProperty("key")
        private String key;

        /** 数据类型。text：字符串；double：数字 */
        @JsonProperty("type")
        private String type;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}
