package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 获取租户资源池下资源包信息 */
public class CtltsGetResourcePackInfoApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsGetResourcePackInfoApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v1/order/resourcePack/pageInfo", "text/plain");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetResourcePackInfoResponse send(
            Credential credential, GetResourcePackInfoRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.pageNum != null) {
            ctReq.addParam("pageNum", String.valueOf(request.pageNum));
            request.pageNum = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        ctReq.writeString("", template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetResourcePackInfoResponse.class);
    }

    public static class GetResourcePackInfoRequest {
        /** 资源池编码，请参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 页码，默认值为1 */
        @JsonProperty("pageNum")
        private Integer pageNum;

        /** 每页条数，默认10；最小1，最大100 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public Integer getPageNum() {
            return this.pageNum;
        }

        public void setPageNum(Integer pageNum) {
            this.pageNum = pageNum;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class GetResourcePackInfoResponse {
        /** 响应状态码。0：代表正常；-1：代表严重错误；-2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 分页响应对象 */
        @JsonProperty("returnObj")
        private GetResourcePackInfoReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetResourcePackInfoReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetResourcePackInfoReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class GetResourcePackInfoReturnObjResponse {
        /** 总记录数 */
        @JsonProperty("total")
        private Long total;

        /** 数据列表 */
        @JsonProperty("list")
        private List<GetResourcePackInfoReturnObjListResponse> list;

        public Long getTotal() {
            return this.total;
        }

        public void setTotal(Long total) {
            this.total = total;
        }

        public List<GetResourcePackInfoReturnObjListResponse> getList() {
            return this.list;
        }

        public void setList(List<GetResourcePackInfoReturnObjListResponse> list) {
            this.list = list;
        }
    }

    public static class GetResourcePackInfoReturnObjListResponse {
        /** 开始时间，单位秒 */
        @JsonProperty("startTime")
        private Long startTime;

        /** 结束时间，单位秒 */
        @JsonProperty("endTime")
        private Long endTime;

        /** 创建时间，单位秒 */
        @JsonProperty("createTime")
        private Long createTime;

        /** 重置时间，单位秒 */
        @JsonProperty("nextStartTime")
        private Long nextStartTime;

        /** 已使用资源包额度 */
        @JsonProperty("usedQuota")
        private Double usedQuota;

        /** 总资源包额度 */
        @JsonProperty("totalQuota")
        private Double totalQuota;

        /** 剩余资源包额度 */
        @JsonProperty("remainQuota")
        private Double remainQuota;

        /** 实例id */
        @JsonProperty("instanceId")
        private String instanceId;

        /** 状态，1：生效中；2：已退订；0：已过期 */
        @JsonProperty("status")
        private Integer status;

        /** 租户id */
        @JsonProperty("tenantId")
        private Long tenantId;

        /** 资源池编码 */
        @JsonProperty("resPoolCode")
        private String resPoolCode;

        public Long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public Long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        public Long getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Long createTime) {
            this.createTime = createTime;
        }

        public Long getNextStartTime() {
            return this.nextStartTime;
        }

        public void setNextStartTime(Long nextStartTime) {
            this.nextStartTime = nextStartTime;
        }

        public Double getUsedQuota() {
            return this.usedQuota;
        }

        public void setUsedQuota(Double usedQuota) {
            this.usedQuota = usedQuota;
        }

        public Double getTotalQuota() {
            return this.totalQuota;
        }

        public void setTotalQuota(Double totalQuota) {
            this.totalQuota = totalQuota;
        }

        public Double getRemainQuota() {
            return this.remainQuota;
        }

        public void setRemainQuota(Double remainQuota) {
            this.remainQuota = remainQuota;
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Long getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(Long tenantId) {
            this.tenantId = tenantId;
        }

        public String getResPoolCode() {
            return this.resPoolCode;
        }

        public void setResPoolCode(String resPoolCode) {
            this.resPoolCode = resPoolCode;
        }
    }
}
