package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 根据标签键值查询日志项目ID列表 */
public class CtltsGetProjectIdByTagApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsGetProjectIdByTagApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/v1/tags/getProjectIdByTag", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetProjectIdByTagResponse send(Credential credential, GetProjectIdByTagRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetProjectIdByTagResponse.class);
    }

    public static class GetProjectIdByTagRequest {
        /** 资源池编码，请参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 标签列表 */
        @JsonProperty("tags")
        private List<GetProjectIdByTagTagsRequest> tags;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public List<GetProjectIdByTagTagsRequest> getTags() {
            return this.tags;
        }

        public void setTags(List<GetProjectIdByTagTagsRequest> tags) {
            this.tags = tags;
        }
    }

    public static class GetProjectIdByTagTagsRequest {
        /** 标签名，最大支持32个字符长度 */
        @JsonProperty("key")
        private String key;

        /** 标签值，最大支持32个字符长度 */
        @JsonProperty("value")
        private String value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class GetProjectIdByTagResponse {
        /** 响应状态码。0：代表正常；-1：代表严重错误；-2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 日志项目ID列表。日志项目列表接口会返回日志项目ID */
        @JsonProperty("returnObj")
        private List<String> returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public List<String> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<String> returnObj) {
            this.returnObj = returnObj;
        }
    }
}
