package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 获取加工任务详细信息 */
public class CtltsGetProcessTaskApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsGetProcessTaskApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v1/dataProcess/getProcessTask", "text/plain");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetProcessTaskResponse send(Credential credential, GetProcessTaskRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.taskCode != null) {
            ctReq.addParam("taskCode", request.taskCode);
            request.taskCode = null;
        }
        ctReq.writeString("", template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetProcessTaskResponse.class);
    }

    public static class GetProcessTaskRequest {
        /** 资源池编码，可参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 任务编码, 可通过列出指定Project下的加工任务接口获取 */
        @JsonProperty("taskCode")
        private String taskCode;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getTaskCode() {
            return this.taskCode;
        }

        public void setTaskCode(String taskCode) {
            this.taskCode = taskCode;
        }
    }

    public static class GetProcessTaskResponse {
        /** 响应状态码。0：代表正常； -1：代表严重错误； -2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求id */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求接口返回的数据体 */
        @JsonProperty("returnObj")
        private GetProcessTaskReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public GetProcessTaskReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetProcessTaskReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class GetProcessTaskReturnObjResponse {
        /** 任务编码 */
        @JsonProperty("taskCode")
        private String taskCode;

        /** 任务名称 */
        @JsonProperty("taskName")
        private String taskName;

        /** 源日志项目ID */
        @JsonProperty("projectCode")
        private String projectCode;

        /** 源日志项目名称 */
        @JsonProperty("projectName")
        private String projectName;

        /** 源日志单元ID */
        @JsonProperty("unitCode")
        private String unitCode;

        /** 源日志单元名称 */
        @JsonProperty("unitName")
        private String unitName;

        /** 加工时间类型。CONTINUOUS：持续投递；RANGE：指定时间点结束 */
        @JsonProperty("processRange")
        private String processRange;

        /** 加工开始时间[毫秒] */
        @JsonProperty("startTime")
        private Long startTime;

        /** 加工结束时间[毫秒] */
        @JsonProperty("endTime")
        private Long endTime;

        /**
         * 任务状态。STARTING：启动中；RUNNING：运行中；SUCCESS：完成；FAIL：失败；STOPPING：停止中；STOPPED：已停止；MODIFIED：修改中
         */
        @JsonProperty("status")
        private String status;

        /** 创建时间[毫秒] */
        @JsonProperty("createTime")
        private Integer createTime;

        /** 目标列表 */
        @JsonProperty("aimList")
        private List<GetProcessTaskReturnObjAimListResponse> aimList;

        public String getTaskCode() {
            return this.taskCode;
        }

        public void setTaskCode(String taskCode) {
            this.taskCode = taskCode;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public void setTaskName(String taskName) {
            this.taskName = taskName;
        }

        public String getProjectCode() {
            return this.projectCode;
        }

        public void setProjectCode(String projectCode) {
            this.projectCode = projectCode;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public String getUnitCode() {
            return this.unitCode;
        }

        public void setUnitCode(String unitCode) {
            this.unitCode = unitCode;
        }

        public String getUnitName() {
            return this.unitName;
        }

        public void setUnitName(String unitName) {
            this.unitName = unitName;
        }

        public String getProcessRange() {
            return this.processRange;
        }

        public void setProcessRange(String processRange) {
            this.processRange = processRange;
        }

        public Long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public Long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public Integer getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Integer createTime) {
            this.createTime = createTime;
        }

        public List<GetProcessTaskReturnObjAimListResponse> getAimList() {
            return this.aimList;
        }

        public void setAimList(List<GetProcessTaskReturnObjAimListResponse> aimList) {
            this.aimList = aimList;
        }
    }

    public static class GetProcessTaskReturnObjAimListResponse {
        /** 目标名称：用户自定义，支持最大64个字符 */
        @JsonProperty("aimName")
        private String aimName;

        /** 目标日志项目ID：下拉列表选择当前租户的所有日志项目 */
        @JsonProperty("aimProjectCode")
        private String aimProjectCode;

        /** 目标日志单元ID：下拉列表展示所选日志项目下的所有日志单元。若未选日志项目，则日志单元禁用不可点击 */
        @JsonProperty("aimUnitCode")
        private String aimUnitCode;

        public String getAimName() {
            return this.aimName;
        }

        public void setAimName(String aimName) {
            this.aimName = aimName;
        }

        public String getAimProjectCode() {
            return this.aimProjectCode;
        }

        public void setAimProjectCode(String aimProjectCode) {
            this.aimProjectCode = aimProjectCode;
        }

        public String getAimUnitCode() {
            return this.aimUnitCode;
        }

        public void setAimUnitCode(String aimUnitCode) {
            this.aimUnitCode = aimUnitCode;
        }
    }
}
