package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用getLogs接口查询日志 */
public class CtltsGetLogsApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsGetLogsApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/v1/content/getLogs", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetLogsResponse send(Credential credential, GetLogsRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetLogsResponse.class);
    }

    public static class GetLogsRequest {
        /** 资源池编码，可参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 日志项目ID 可在云日志控制台 日志管理 -> 日志项目列表 -> 鼠标悬浮查看日志项目ID */
        @JsonProperty("projectCode")
        private String projectCode;

        /** 日志单元ID 可在云日志控制台 日志管理 -> 日志项目列表 -> 展开单元列表 -> 鼠标悬浮查看日志单元ID */
        @JsonProperty("unitCode")
        private String unitCode;

        /** 起始时间(秒级) */
        @JsonProperty("startTime")
        private Long startTime;

        /** 结束时间(秒级) */
        @JsonProperty("endTime")
        private Long endTime;

        /** 查询语句或者分析语句 示例： 查询语句：status:200 分析语句：status:200 | select count(*) from log */
        @JsonProperty("query")
        private String query;

        /**
         * 结果是否按时间倒序(默认false) 1、当query参数为查询语句时，参数reverse有效，用于指定返回日志时间排序方式。
         * 2、当query参数为查询和分析语句时，参数reverse无效。
         */
        @JsonProperty("reverse")
        private Boolean reverse;

        /**
         * 默取值为forward（默认）或backward。翻页查询模式，表示在当前页状态下，前进翻页还是后退翻页，可搭配cursor参数使用。
         * 例如：当前在第2页，如果需后退翻至第1页则填入backward，并且cursor填入第2页响应的第一条记录的 __cursor__ 即可回到第1页的数据列
         */
        @JsonProperty("searchType")
        private String searchType;

        /** 限制返回的日志数量(默认100)，最大限制5000 */
        @JsonProperty("limit")
        private Integer limit;

        /** 仅当query参数为查询语句时，该参数有效，表示查询开始行。默认值为为空代表从第1页开始。 例如：如果想翻第二页，则填入第1页响应的最后一行 __cursor__ 即可。 */
        @JsonProperty("cursor")
        private String cursor;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProjectCode() {
            return this.projectCode;
        }

        public void setProjectCode(String projectCode) {
            this.projectCode = projectCode;
        }

        public String getUnitCode() {
            return this.unitCode;
        }

        public void setUnitCode(String unitCode) {
            this.unitCode = unitCode;
        }

        public Long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public Long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        public String getQuery() {
            return this.query;
        }

        public void setQuery(String query) {
            this.query = query;
        }

        public Boolean getReverse() {
            return this.reverse;
        }

        public void setReverse(Boolean reverse) {
            this.reverse = reverse;
        }

        public String getSearchType() {
            return this.searchType;
        }

        public void setSearchType(String searchType) {
            this.searchType = searchType;
        }

        public Integer getLimit() {
            return this.limit;
        }

        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        public String getCursor() {
            return this.cursor;
        }

        public void setCursor(String cursor) {
            this.cursor = cursor;
        }
    }

    public static class GetLogsResponse {
        /** 响应状态码。0：代表正常； -1：代表严重错误； -2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 调用错误时返回的错误编码 */
        @JsonProperty("error")
        private String error;

        /** 消息内容 */
        @JsonProperty("message")
        private String message;

        /** 请求id */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求响应体 */
        @JsonProperty("returnObj")
        private GetLogsReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public GetLogsReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetLogsReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class GetLogsReturnObjResponse {
        /** 日志数据 */
        @JsonProperty("logs")
        private List<GetLogsReturnObjLogsResponse> logs;

        /** 本次查询返回的日志条数 */
        @JsonProperty("count")
        private Integer count;

        public List<GetLogsReturnObjLogsResponse> getLogs() {
            return this.logs;
        }

        public void setLogs(List<GetLogsReturnObjLogsResponse> logs) {
            this.logs = logs;
        }

        public Integer getCount() {
            return this.count;
        }

        public void setCount(Integer count) {
            this.count = count;
        }
    }

    public static class GetLogsReturnObjLogsResponse {
        /** 日志行标 */
        @JsonProperty("__cursor__")
        private String __cursor__;

        /** 日志原文 */
        @JsonProperty("__message__")
        private String __message__;

        /** 自定义索引字段1 */
        @JsonProperty("key1")
        private String key1;

        /** 自定义索引字段2 */
        @JsonProperty("key2")
        private String key2;

        public String get__cursor__() {
            return this.__cursor__;
        }

        public void set__cursor__(String __cursor__) {
            this.__cursor__ = __cursor__;
        }

        public String get__message__() {
            return this.__message__;
        }

        public void set__message__(String __message__) {
            this.__message__ = __message__;
        }

        public String getKey1() {
            return this.key1;
        }

        public void setKey1(String key1) {
            this.key1 = key1;
        }

        public String getKey2() {
            return this.key2;
        }

        public void setKey2(String key2) {
            this.key2 = key2;
        }
    }
}
