package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 获取指定的kafka投递任务。 */
public class CtltsGetKafkaDataSendTaskApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsGetKafkaDataSendTaskApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v1/dataSend/getKafkaTask", "text/plain");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetKafkaDataSendTaskResponse send(
            Credential credential, GetKafkaDataSendTaskRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.taskCode != null) {
            ctReq.addParam("taskCode", request.taskCode);
            request.taskCode = null;
        }
        ctReq.writeString("", template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetKafkaDataSendTaskResponse.class);
    }

    public static class GetKafkaDataSendTaskRequest {
        /** 资源池编码，可参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 任务编码, 可通过列出指定项目下的kafka投递任务接口获取 */
        @JsonProperty("taskCode")
        private String taskCode;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getTaskCode() {
            return this.taskCode;
        }

        public void setTaskCode(String taskCode) {
            this.taskCode = taskCode;
        }
    }

    public static class GetKafkaDataSendTaskResponse {
        /** 响应状态码。0：代表正常； -1：代表严重错误； -2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求id */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求返回体 */
        @JsonProperty("returnObj")
        private GetKafkaDataSendTaskReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public GetKafkaDataSendTaskReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetKafkaDataSendTaskReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class GetKafkaDataSendTaskReturnObjResponse {
        /** 任务编码 */
        @JsonProperty("taskCode")
        private String taskCode;

        /** 任务名称 */
        @JsonProperty("taskName")
        private String taskName;

        /** 投递任务配置 */
        @JsonProperty("instanceConfig")
        private GetKafkaDataSendTaskReturnObjInstanceConfigResponse instanceConfig;

        /** 项目ID */
        @JsonProperty("projectCode")
        private String projectCode;

        /** 项目名称 */
        @JsonProperty("projectName")
        private String projectName;

        /** 单元ID */
        @JsonProperty("unitCode")
        private String unitCode;

        /** 单元名称 */
        @JsonProperty("unitName")
        private String unitName;

        /** 投递类型。CONTINUOUS：持续投递；RANGE：指定时间点结束 */
        @JsonProperty("processRange")
        private String processRange;

        /** 投递开始时间[毫秒] */
        @JsonProperty("startTime")
        private Long startTime;

        /** 投递结束时间[毫秒] */
        @JsonProperty("endTime")
        private Long endTime;

        /**
         * 任务状态。STARTING：启动中；RUNNING：运行中；SUCCESS：完成；FAIL：失败；STOPPING：停止中；STOPPED：已停止；MODIFIED：修改中
         */
        @JsonProperty("status")
        private String status;

        /** 任务创建时间[毫秒] */
        @JsonProperty("createTime")
        private Long createTime;

        public String getTaskCode() {
            return this.taskCode;
        }

        public void setTaskCode(String taskCode) {
            this.taskCode = taskCode;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public void setTaskName(String taskName) {
            this.taskName = taskName;
        }

        public GetKafkaDataSendTaskReturnObjInstanceConfigResponse getInstanceConfig() {
            return this.instanceConfig;
        }

        public void setInstanceConfig(
                GetKafkaDataSendTaskReturnObjInstanceConfigResponse instanceConfig) {
            this.instanceConfig = instanceConfig;
        }

        public String getProjectCode() {
            return this.projectCode;
        }

        public void setProjectCode(String projectCode) {
            this.projectCode = projectCode;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public String getUnitCode() {
            return this.unitCode;
        }

        public void setUnitCode(String unitCode) {
            this.unitCode = unitCode;
        }

        public String getUnitName() {
            return this.unitName;
        }

        public void setUnitName(String unitName) {
            this.unitName = unitName;
        }

        public String getProcessRange() {
            return this.processRange;
        }

        public void setProcessRange(String processRange) {
            this.processRange = processRange;
        }

        public Long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public Long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public Long getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Long createTime) {
            this.createTime = createTime;
        }
    }

    public static class GetKafkaDataSendTaskReturnObjInstanceConfigResponse {
        /** kafka实例id */
        @JsonProperty("instanceId")
        private String instanceId;

        /** kafka地址 */
        @JsonProperty("instance")
        private String instance;

        /** kafka topic */
        @JsonProperty("topic")
        private String topic;

        /** 是否开启投递kafka带项目单元的标签数据。1：开启；0：关闭 */
        @JsonProperty("abledSendTags")
        private String abledSendTags;

        public String getInstanceId() {
            return this.instanceId;
        }

        public void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public String getInstance() {
            return this.instance;
        }

        public void setInstance(String instance) {
            this.instance = instance;
        }

        public String getTopic() {
            return this.topic;
        }

        public void setTopic(String topic) {
            this.topic = topic;
        }

        public String getAbledSendTags() {
            return this.abledSendTags;
        }

        public void setAbledSendTags(String abledSendTags) {
            this.abledSendTags = abledSendTags;
        }
    }
}
