package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 获取租户资源池下实例信息 */
public class CtltsGetInstanceInfoApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsGetInstanceInfoApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v1/usage/instance/getInstanceInfo", "text/plain");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetInstanceInfoResponse send(Credential credential, GetInstanceInfoRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeString("", template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetInstanceInfoResponse.class);
    }

    public static class GetInstanceInfoRequest {
        /** 资源池编码，请参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }
    }

    public static class GetInstanceInfoResponse {
        /** 响应状态码。0：代表正常；-1：代表严重错误；-2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求响应数据体 */
        @JsonProperty("returnObj")
        private GetInstanceInfoReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetInstanceInfoReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetInstanceInfoReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class GetInstanceInfoReturnObjResponse {
        /** 实例名称 */
        @JsonProperty("orderInstName")
        private String orderInstName;

        /** 实例ID */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /** 生效开始时间 */
        @JsonProperty("licenseBeginTime")
        private String licenseBeginTime;

        /** 生效结束时间 */
        @JsonProperty("licenseExpireTime")
        private String licenseExpireTime;

        public String getOrderInstName() {
            return this.orderInstName;
        }

        public void setOrderInstName(String orderInstName) {
            this.orderInstName = orderInstName;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getLicenseBeginTime() {
            return this.licenseBeginTime;
        }

        public void setLicenseBeginTime(String licenseBeginTime) {
            this.licenseBeginTime = licenseBeginTime;
        }

        public String getLicenseExpireTime() {
            return this.licenseExpireTime;
        }

        public void setLicenseExpireTime(String licenseExpireTime) {
            this.licenseExpireTime = licenseExpireTime;
        }
    }
}
