package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 获取租户资源池下实例信息 */
public class CtltsGetInstanceDetailApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsGetInstanceDetailApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v1/order/instance/info", "text/plain");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetInstanceDetailResponse send(Credential credential, GetInstanceDetailRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeString("", template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetInstanceDetailResponse.class);
    }

    public static class GetInstanceDetailRequest {
        /** 资源池编码，请参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }
    }

    public static class GetInstanceDetailResponse {
        /** 响应状态码。0：代表正常；-1：代表严重错误；-2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求响应数据体 */
        @JsonProperty("returnObj")
        private GetInstanceDetailReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetInstanceDetailReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetInstanceDetailReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class GetInstanceDetailReturnObjResponse {
        /** 资源池编码 */
        @JsonProperty("resPoolCode")
        private String resPoolCode;

        /** 订单实例id */
        @JsonProperty("tenantOrderInstId")
        private Long tenantOrderInstId;

        /** 实例名称 */
        @JsonProperty("orderInstName")
        private String orderInstName;

        /** 实例id */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /** 开始时间 */
        @JsonProperty("licenseBeginTime")
        private String licenseBeginTime;

        /** 结束时间 */
        @JsonProperty("licenseExpireTime")
        private String licenseExpireTime;

        /** 租户id */
        @JsonProperty("tenantId")
        private Long tenantId;

        /** 订单状态，0：无效；1：有效；2：已删除 */
        @JsonProperty("status")
        private Byte status;

        /** 创建人id */
        @JsonProperty("createdBy")
        private Long createdBy;

        /** 创建时间 */
        @JsonProperty("createdTime")
        private String createdTime;

        /** 更新时间 */
        @JsonProperty("modifiedTime")
        private String modifiedTime;

        /** 更新人id */
        @JsonProperty("modifiedBy")
        private Long modifiedBy;

        /** 订单凭证编码 */
        @JsonProperty("orderLicenseCode")
        private String orderLicenseCode;

        public String getResPoolCode() {
            return this.resPoolCode;
        }

        public void setResPoolCode(String resPoolCode) {
            this.resPoolCode = resPoolCode;
        }

        public Long getTenantOrderInstId() {
            return this.tenantOrderInstId;
        }

        public void setTenantOrderInstId(Long tenantOrderInstId) {
            this.tenantOrderInstId = tenantOrderInstId;
        }

        public String getOrderInstName() {
            return this.orderInstName;
        }

        public void setOrderInstName(String orderInstName) {
            this.orderInstName = orderInstName;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getLicenseBeginTime() {
            return this.licenseBeginTime;
        }

        public void setLicenseBeginTime(String licenseBeginTime) {
            this.licenseBeginTime = licenseBeginTime;
        }

        public String getLicenseExpireTime() {
            return this.licenseExpireTime;
        }

        public void setLicenseExpireTime(String licenseExpireTime) {
            this.licenseExpireTime = licenseExpireTime;
        }

        public Long getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(Long tenantId) {
            this.tenantId = tenantId;
        }

        public Byte getStatus() {
            return this.status;
        }

        public void setStatus(Byte status) {
            this.status = status;
        }

        public Long getCreatedBy() {
            return this.createdBy;
        }

        public void setCreatedBy(Long createdBy) {
            this.createdBy = createdBy;
        }

        public String getCreatedTime() {
            return this.createdTime;
        }

        public void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        public String getModifiedTime() {
            return this.modifiedTime;
        }

        public void setModifiedTime(String modifiedTime) {
            this.modifiedTime = modifiedTime;
        }

        public Long getModifiedBy() {
            return this.modifiedBy;
        }

        public void setModifiedBy(Long modifiedBy) {
            this.modifiedBy = modifiedBy;
        }

        public String getOrderLicenseCode() {
            return this.orderLicenseCode;
        }

        public void setOrderLicenseCode(String orderLicenseCode) {
            this.orderLicenseCode = orderLicenseCode;
        }
    }
}
