package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 获取日志采集器安装命令 */
public class CtltsGetInstallCmdApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsGetInstallCmdApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/v1/hostGroup/host/installCmd", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetInstallCmdResponse send(Credential credential, GetInstallCmdRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetInstallCmdResponse.class);
    }

    public static class GetInstallCmdRequest {
        /** 资源池编码，请参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 主机类型。 internalHost：区域内主机； externalHost：区域外主机。目前仅支持区域内主机 */
        @JsonProperty("hostSource")
        private String hostSource;

        /** 安装系统。 可选 linux、windows */
        @JsonProperty("osType")
        private String osType;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getHostSource() {
            return this.hostSource;
        }

        public void setHostSource(String hostSource) {
            this.hostSource = hostSource;
        }

        public String getOsType() {
            return this.osType;
        }

        public void setOsType(String osType) {
            this.osType = osType;
        }
    }

    public static class GetInstallCmdResponse {
        /** 响应状态码。0：代表正常； -1：代表严重错误； -2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码,仅错误时返回,例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求接口返回的数据体 */
        @JsonProperty("returnObj")
        private GetInstallCmdReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetInstallCmdReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetInstallCmdReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class GetInstallCmdReturnObjResponse {
        /** 安装命令 */
        @JsonProperty("cmd")
        private String cmd;

        /** 安装包名称 */
        @JsonProperty("packageName")
        private String packageName;

        /** 安装包下载地址 */
        @JsonProperty("packageUrl")
        private String packageUrl;

        public String getCmd() {
            return this.cmd;
        }

        public void setCmd(String cmd) {
            this.cmd = cmd;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getPackageUrl() {
            return this.packageUrl;
        }

        public void setPackageUrl(String packageUrl) {
            this.packageUrl = packageUrl;
        }
    }
}
