package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 获取主机组详情 */
public class CtltsGetHostGroupApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsGetHostGroupApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(ENDPOINT_NAME, "GET", "/v1/hostGroup/get", "text/plain");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetHostGroupResponse send(Credential credential, GetHostGroupRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.hostGroupCode != null) {
            ctReq.addParam("hostGroupCode", request.hostGroupCode);
            request.hostGroupCode = null;
        }
        if (request.hostGroupName != null) {
            ctReq.addParam("hostGroupName", request.hostGroupName);
            request.hostGroupName = null;
        }
        ctReq.writeString("", template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetHostGroupResponse.class);
    }

    public static class GetHostGroupRequest {
        /** 资源池编码，可参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 主机组编码。创建主机组接口会返回主机组编码，方便后续查找。该参数和hostGroupName二选一必填 */
        @JsonProperty("hostGroupCode")
        private String hostGroupCode;

        /** 主机组名称。主机组列表查询接口会返回主机组编码，方便后续查找。该参数和hostGroupCode二选一必填 */
        @JsonProperty("hostGroupName")
        private String hostGroupName;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getHostGroupCode() {
            return this.hostGroupCode;
        }

        public void setHostGroupCode(String hostGroupCode) {
            this.hostGroupCode = hostGroupCode;
        }

        public String getHostGroupName() {
            return this.hostGroupName;
        }

        public void setHostGroupName(String hostGroupName) {
            this.hostGroupName = hostGroupName;
        }
    }

    public static class GetHostGroupResponse {
        /** 响应状态码。0：代表正常； -1：代表严重错误； -2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 主机组对象 */
        @JsonProperty("returnObj")
        private GetHostGroupReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public GetHostGroupReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetHostGroupReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class GetHostGroupReturnObjResponse {
        /** 主机组编码 */
        @JsonProperty("hostGroupCode")
        private String hostGroupCode;

        /** 主机组名称 */
        @JsonProperty("hostGroupName")
        private String hostGroupName;

        /** 主机组描述 */
        @JsonProperty("description")
        private String description;

        /**
         * 主机组类型标识符。支持uuid和sign(自定义标识)，可参考<a
         * href="https://www.ctyun.cn/document/10261471/10977630">主机组管理</a>
         */
        @JsonProperty("hostIdentityType")
        private String hostIdentityType;

        /** 主机对象列表 */
        @JsonProperty("hostList")
        private List<GetHostGroupReturnObjHostListResponse> hostList;

        /** 自定义标识列表。当hostIdentityType=sign时该出参有值 */
        @JsonProperty("signList")
        private List<String> signList;

        public String getHostGroupCode() {
            return this.hostGroupCode;
        }

        public void setHostGroupCode(String hostGroupCode) {
            this.hostGroupCode = hostGroupCode;
        }

        public String getHostGroupName() {
            return this.hostGroupName;
        }

        public void setHostGroupName(String hostGroupName) {
            this.hostGroupName = hostGroupName;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getHostIdentityType() {
            return this.hostIdentityType;
        }

        public void setHostIdentityType(String hostIdentityType) {
            this.hostIdentityType = hostIdentityType;
        }

        public List<GetHostGroupReturnObjHostListResponse> getHostList() {
            return this.hostList;
        }

        public void setHostList(List<GetHostGroupReturnObjHostListResponse> hostList) {
            this.hostList = hostList;
        }

        public List<String> getSignList() {
            return this.signList;
        }

        public void setSignList(List<String> signList) {
            this.signList = signList;
        }
    }

    public static class GetHostGroupReturnObjHostListResponse {
        /** 主机编码 */
        @JsonProperty("hostCode")
        private String hostCode;

        /** 主机名称 */
        @JsonProperty("hostName")
        private String hostName;

        /** 主机UUID */
        @JsonProperty("hostUuid")
        private String hostUuid;

        /** 主机IP */
        @JsonProperty("hostIp")
        private String hostIp;

        /** 主机所属vpc名称 */
        @JsonProperty("vpcName")
        private String vpcName;

        /** 主机连通性。1：联通； 2：未联通；3：检测中 */
        @JsonProperty("linkedStatus")
        private Byte linkedStatus;

        public String getHostCode() {
            return this.hostCode;
        }

        public void setHostCode(String hostCode) {
            this.hostCode = hostCode;
        }

        public String getHostName() {
            return this.hostName;
        }

        public void setHostName(String hostName) {
            this.hostName = hostName;
        }

        public String getHostUuid() {
            return this.hostUuid;
        }

        public void setHostUuid(String hostUuid) {
            this.hostUuid = hostUuid;
        }

        public String getHostIp() {
            return this.hostIp;
        }

        public void setHostIp(String hostIp) {
            this.hostIp = hostIp;
        }

        public String getVpcName() {
            return this.vpcName;
        }

        public void setVpcName(String vpcName) {
            this.vpcName = vpcName;
        }

        public Byte getLinkedStatus() {
            return this.linkedStatus;
        }

        public void setLinkedStatus(Byte linkedStatus) {
            this.linkedStatus = linkedStatus;
        }
    }
}
