package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 根据任务ID查询任务读取行数 */
public class CtltsGetDataSendInputRowApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsGetDataSendInputRowApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v1/dataSend/getInputRow", "text/plain");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetDataSendInputRowResponse send(
            Credential credential, GetDataSendInputRowRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.taskCode != null) {
            ctReq.addParam("taskCode", request.taskCode);
            request.taskCode = null;
        }
        if (request.from != null) {
            ctReq.addParam("from", String.valueOf(request.from));
            request.from = null;
        }
        if (request.to != null) {
            ctReq.addParam("to", String.valueOf(request.to));
            request.to = null;
        }
        ctReq.writeString("", template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetDataSendInputRowResponse.class);
    }

    public static class GetDataSendInputRowRequest {
        /** 资源池编码 */
        @JsonProperty("regionId")
        private String regionId;

        /** 任务code */
        @JsonProperty("taskCode")
        private String taskCode;

        /** 开始时间戳（毫秒） */
        @JsonProperty("from")
        private Long from;

        /** 结束时间戳（毫秒） */
        @JsonProperty("to")
        private Long to;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getTaskCode() {
            return this.taskCode;
        }

        public void setTaskCode(String taskCode) {
            this.taskCode = taskCode;
        }

        public Long getFrom() {
            return this.from;
        }

        public void setFrom(Long from) {
            this.from = from;
        }

        public Long getTo() {
            return this.to;
        }

        public void setTo(Long to) {
            this.to = to;
        }
    }

    public static class GetDataSendInputRowResponse {
        /** 响应编码。0:正常; -1:严重错误; -2:普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 调用错误时返回的错误编码 */
        @JsonProperty("error")
        private String error;

        /** 消息内容 */
        @JsonProperty("message")
        private String message;

        /** 请求id */
        @JsonProperty("requestId")
        private String requestId;

        /** 数量 */
        @JsonProperty("returnObj")
        private Double returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public Double getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(Double returnObj) {
            this.returnObj = returnObj;
        }
    }
}
