package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 获取指定下载任务信息。 */
public class CtltsGetDataDownloadTaskApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsGetDataDownloadTaskApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v1/dataDownload/query", "text/plain");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetDataDownloadTaskResponse send(
            Credential credential, GetDataDownloadTaskRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.taskCode != null) {
            ctReq.addParam("taskCode", request.taskCode);
            request.taskCode = null;
        }
        ctReq.writeString("", template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetDataDownloadTaskResponse.class);
    }

    public static class GetDataDownloadTaskRequest {
        /** 资源池编码，可参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 任务编码, 可在通过获取指定单元下载任务列表接口获取 */
        @JsonProperty("taskCode")
        private String taskCode;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getTaskCode() {
            return this.taskCode;
        }

        public void setTaskCode(String taskCode) {
            this.taskCode = taskCode;
        }
    }

    public static class GetDataDownloadTaskResponse {
        /** 响应状态码。0：代表正常； -1：代表严重错误； -2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求id */
        @JsonProperty("requestId")
        private String requestId;

        /** 下载任务信息 */
        @JsonProperty("returnObj")
        private GetDataDownloadTaskReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public GetDataDownloadTaskReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetDataDownloadTaskReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class GetDataDownloadTaskReturnObjResponse {
        /** 任务编码 */
        @JsonProperty("taskCode")
        private String taskCode;

        /** 任务状态。RUNNING：运行中；SUCCESS：完成 */
        @JsonProperty("status")
        private String status;

        /** 创建时间 */
        @JsonProperty("createTime")
        private String createTime;

        /** 查询开始时间(秒) */
        @JsonProperty("from")
        private Long from;

        /** 查询结束时间(秒) */
        @JsonProperty("to")
        private Long to;

        /** 查询语句 */
        @JsonProperty("query")
        private String query;

        /** 文件格式。json：json格式；csv：csv格式 */
        @JsonProperty("format")
        private String format;

        /** 下载日志数量 */
        @JsonProperty("count")
        private Long count;

        /** 下载链接 */
        @JsonProperty("signUrl")
        private String signUrl;

        /** 日志是否按照日志时间倒叙。 false：日志按照时间正序；true：日志按照时间倒叙 */
        @JsonProperty("reverse")
        private Boolean reverse;

        /** 下载进度信息 */
        @JsonProperty("message")
        private String message;

        /** 文件是否截断(下载日志超过200m自动截断) false：未截断；true：截断 */
        @JsonProperty("cut")
        private Boolean cut;

        public String getTaskCode() {
            return this.taskCode;
        }

        public void setTaskCode(String taskCode) {
            this.taskCode = taskCode;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        public Long getFrom() {
            return this.from;
        }

        public void setFrom(Long from) {
            this.from = from;
        }

        public Long getTo() {
            return this.to;
        }

        public void setTo(Long to) {
            this.to = to;
        }

        public String getQuery() {
            return this.query;
        }

        public void setQuery(String query) {
            this.query = query;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public Long getCount() {
            return this.count;
        }

        public void setCount(Long count) {
            this.count = count;
        }

        public String getSignUrl() {
            return this.signUrl;
        }

        public void setSignUrl(String signUrl) {
            this.signUrl = signUrl;
        }

        public Boolean getReverse() {
            return this.reverse;
        }

        public void setReverse(Boolean reverse) {
            this.reverse = reverse;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public Boolean getCut() {
            return this.cut;
        }

        public void setCut(Boolean cut) {
            this.cut = cut;
        }
    }
}
