package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 查询采集配置状态 */
public class CtltsGetCollectRuleStatusApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsGetCollectRuleStatusApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v1/collectorRule/getRuleStatus", "text/plain");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetCollectRuleStatusResponse send(
            Credential credential, GetCollectRuleStatusRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.ruleCode != null) {
            ctReq.addParam("ruleCode", request.ruleCode);
            request.ruleCode = null;
        }
        ctReq.writeString("", template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetCollectRuleStatusResponse.class);
    }

    public static class GetCollectRuleStatusRequest {
        /** 资源池编码，请参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 采集规则编码 */
        @JsonProperty("ruleCode")
        private String ruleCode;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getRuleCode() {
            return this.ruleCode;
        }

        public void setRuleCode(String ruleCode) {
            this.ruleCode = ruleCode;
        }
    }

    public static class GetCollectRuleStatusResponse {
        /** 响应状态码。0：代表正常；-1：代表严重错误；-2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 采集规则状态响应体 */
        @JsonProperty("returnObj")
        private GetCollectRuleStatusReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetCollectRuleStatusReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetCollectRuleStatusReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class GetCollectRuleStatusReturnObjResponse {
        /** 采集规则编码 */
        @JsonProperty("ruleCode")
        private String ruleCode;

        /** 状态，1：启用；0：停用 */
        @JsonProperty("status")
        private Byte status;

        public String getRuleCode() {
            return this.ruleCode;
        }

        public void setRuleCode(String ruleCode) {
            this.ruleCode = ruleCode;
        }

        public Byte getStatus() {
            return this.status;
        }

        public void setStatus(Byte status) {
            this.status = status;
        }
    }
}
