package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 获取云主机列表 */
public class CtltsEcsPageListApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsEcsPageListApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v1/hostGroup/ecsPageList", "text/plain");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public EcsPageListResponse send(Credential credential, EcsPageListRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.instanceName != null) {
            ctReq.addParam("instanceName", request.instanceName);
            request.instanceName = null;
        }
        if (request.ipv4 != null) {
            ctReq.addParam("ipv4", request.ipv4);
            request.ipv4 = null;
        }
        if (request.pageNum != null) {
            ctReq.addParam("pageNum", String.valueOf(request.pageNum));
            request.pageNum = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        ctReq.writeString("", template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(EcsPageListResponse.class);
    }

    public static class EcsPageListRequest {
        /** 资源池编码，请参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 云主机名称，支持模糊查询 */
        @JsonProperty("instanceName")
        private String instanceName;

        /** 云主机内网IP，支持模糊查询 */
        @JsonProperty("ipv4")
        private String ipv4;

        /** 页码，默认是1 */
        @JsonProperty("pageNum")
        private Integer pageNum;

        /** 每页数量， 默认是10 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public String getIpv4() {
            return this.ipv4;
        }

        public void setIpv4(String ipv4) {
            this.ipv4 = ipv4;
        }

        public Integer getPageNum() {
            return this.pageNum;
        }

        public void setPageNum(Integer pageNum) {
            this.pageNum = pageNum;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class EcsPageListResponse {
        /** 响应状态码。0：代表正常； -1：代表严重错误； -2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 分页响应对象 */
        @JsonProperty("returnObj")
        private EcsPageListReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public EcsPageListReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(EcsPageListReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class EcsPageListReturnObjResponse {
        /** 总记录数 */
        @JsonProperty("total")
        private Long total;

        /** 数据列表 */
        @JsonProperty("list")
        private List<EcsPageListReturnObjListResponse> list;

        public Long getTotal() {
            return this.total;
        }

        public void setTotal(Long total) {
            this.total = total;
        }

        public List<EcsPageListReturnObjListResponse> getList() {
            return this.list;
        }

        public void setList(List<EcsPageListReturnObjListResponse> list) {
            this.list = list;
        }
    }

    public static class EcsPageListReturnObjListResponse {
        /** 机器名称 */
        @JsonProperty("hostName")
        private String hostName;

        /** 机器实例ID */
        @JsonProperty("instanceId")
        private String instanceId;

        /** 操作系统 */
        @JsonProperty("osType")
        private String osType;

        /** vpcID */
        @JsonProperty("vpcId")
        private String vpcId;

        /** vpc名称 */
        @JsonProperty("vpcName")
        private String vpcName;

        /** 主网卡内网IPv4地址 */
        @JsonProperty("privateIP")
        private String privateIP;

        public String getHostName() {
            return this.hostName;
        }

        public void setHostName(String hostName) {
            this.hostName = hostName;
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public String getOsType() {
            return this.osType;
        }

        public void setOsType(String osType) {
            this.osType = osType;
        }

        public String getVpcId() {
            return this.vpcId;
        }

        public void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public String getVpcName() {
            return this.vpcName;
        }

        public void setVpcName(String vpcName) {
            this.vpcName = vpcName;
        }

        public String getPrivateIP() {
            return this.privateIP;
        }

        public void setPrivateIP(String privateIP) {
            this.privateIP = privateIP;
        }
    }
}
