package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 列取订阅的联系人。 */
public class CtltsDashboardSubscribeContactListApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsDashboardSubscribeContactListApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v1/dashboard/subscribe/listContact", "text/plain");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DashboardSubscribeContactListResponse send(
            Credential credential, DashboardSubscribeContactListRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.subscriptionCodeList != null) {
            ctReq.addParam("subscriptionCodeList", request.subscriptionCodeList);
            request.subscriptionCodeList = null;
        }
        ctReq.writeString("", template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DashboardSubscribeContactListResponse.class);
    }

    public static class DashboardSubscribeContactListRequest {
        /** 资源池编码，可参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 订阅编码列表，英文（半角）逗号分割。可以从列取仪表盘订阅接口（listDashboardSubscribe）获取。 */
        @JsonProperty("subscriptionCodeList")
        private String subscriptionCodeList;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getSubscriptionCodeList() {
            return this.subscriptionCodeList;
        }

        public void setSubscriptionCodeList(String subscriptionCodeList) {
            this.subscriptionCodeList = subscriptionCodeList;
        }
    }

    public static class DashboardSubscribeContactListResponse {
        /** 响应状态码。0：正常；-1：代表严重错误；-2：代表普通错误。 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX。 */
        @JsonProperty("error")
        private String error;

        /** 消息内容。 */
        @JsonProperty("message")
        private String message;

        /** 请求ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 联系人列表。 */
        @JsonProperty("returnObj")
        private List<DashboardSubscribeContactListReturnObjResponse> returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public List<DashboardSubscribeContactListReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<DashboardSubscribeContactListReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class DashboardSubscribeContactListReturnObjResponse {
        /** 订阅编码。 */
        @JsonProperty("dashboardSubscriptionCode")
        private String dashboardSubscriptionCode;

        /** 联系人列表。 */
        @JsonProperty("contacts")
        private List<DashboardSubscribeContactListReturnObjContactsResponse> contacts;

        public String getDashboardSubscriptionCode() {
            return this.dashboardSubscriptionCode;
        }

        public void setDashboardSubscriptionCode(String dashboardSubscriptionCode) {
            this.dashboardSubscriptionCode = dashboardSubscriptionCode;
        }

        public List<DashboardSubscribeContactListReturnObjContactsResponse> getContacts() {
            return this.contacts;
        }

        public void setContacts(
                List<DashboardSubscribeContactListReturnObjContactsResponse> contacts) {
            this.contacts = contacts;
        }
    }

    public static class DashboardSubscribeContactListReturnObjContactsResponse {
        /** 姓名 */
        @JsonProperty("name")
        private String name;

        /** 邮箱 */
        @JsonProperty("email")
        private String email;

        /** 电话 */
        @JsonProperty("mobile")
        private String mobile;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getMobile() {
            return this.mobile;
        }

        public void setMobile(String mobile) {
            this.mobile = mobile;
        }
    }
}
