package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 通过名称获取仪表盘编码。 */
public class CtltsDashboardGetCodeApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsDashboardGetCodeApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(ENDPOINT_NAME, "GET", "/v1/dashboard/get", "text/plain");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DashboardGetCodeResponse send(Credential credential, DashboardGetCodeRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.dashboardName != null) {
            ctReq.addParam("dashboardName", request.dashboardName);
            request.dashboardName = null;
        }
        ctReq.writeString("", template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DashboardGetCodeResponse.class);
    }

    public static class DashboardGetCodeRequest {
        /** 资源池编码，可参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 仪表盘名称。 */
        @JsonProperty("dashboardName")
        private String dashboardName;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getDashboardName() {
            return this.dashboardName;
        }

        public void setDashboardName(String dashboardName) {
            this.dashboardName = dashboardName;
        }
    }

    public static class DashboardGetCodeResponse {
        /** 响应状态码。0：正常；-1：代表严重错误；-2：代表普通错误。 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX。 */
        @JsonProperty("error")
        private String error;

        /** 消息内容。 */
        @JsonProperty("message")
        private String message;

        /** 请求ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 返回的仪表盘编码。 */
        @JsonProperty("returnObj")
        private String returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(String returnObj) {
            this.returnObj = returnObj;
        }
    }
}
