package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 创建一个仪表盘。 */
public class CtltsDashboardCreateApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsDashboardCreateApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/v1/dashboard/create", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DashboardCreateResponse send(Credential credential, DashboardCreateRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DashboardCreateResponse.class);
    }

    public static class DashboardCreateRequest {
        /** 资源池编码，可参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 应用于该仪表盘对应的项目编码。 */
        @JsonProperty("projectCode")
        private String projectCode;

        /** 应用于该仪表盘对应的单元编码。 */
        @JsonProperty("unitCode")
        private String unitCode;

        /** 仪表盘名称。名称限制为：1~64位字符，字符限制为任意字母（包括但不限于ASCII字母和其他语言的字母）、数字0-9，以及横线-。同一租户的同一资源池下命名不可重复。 */
        @JsonProperty("dashboardName")
        private String dashboardName;

        /** 仪表盘描述。字符长度不超过500。 */
        @JsonProperty("description")
        private String description;

        /** 仪表盘模板名称，详见 templateType 枚举。 */
        @JsonProperty("templateType")
        private String templateType;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProjectCode() {
            return this.projectCode;
        }

        public void setProjectCode(String projectCode) {
            this.projectCode = projectCode;
        }

        public String getUnitCode() {
            return this.unitCode;
        }

        public void setUnitCode(String unitCode) {
            this.unitCode = unitCode;
        }

        public String getDashboardName() {
            return this.dashboardName;
        }

        public void setDashboardName(String dashboardName) {
            this.dashboardName = dashboardName;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getTemplateType() {
            return this.templateType;
        }

        public void setTemplateType(String templateType) {
            this.templateType = templateType;
        }
    }

    public static class DashboardCreateResponse {
        /** 响应状态码。0：正常；-1：代表严重错误；-2：代表普通错误。 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX。 */
        @JsonProperty("error")
        private String error;

        /** 消息内容。 */
        @JsonProperty("message")
        private String message;

        /** 请求ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 仪表盘编码。 */
        @JsonProperty("returnObj")
        private String returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(String returnObj) {
            this.returnObj = returnObj;
        }
    }
}
