package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 创建消费组。（邀测功能，仅白名单用户可调用） */
public class CtltsCreateconsumerGroupApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsCreateconsumerGroupApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/v1/consumerGroup/create", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CreateconsumerGroupResponse send(
            Credential credential, CreateconsumerGroupRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreateconsumerGroupResponse.class);
    }

    public static class CreateconsumerGroupRequest {
        /** 资源池编码，可参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 消费者组名前缀（注意：消费组名称由自定义前缀 + 随机串生成，保存成功后即可查看完整名称，后续则使用完整的名称才能进行消费，不能单独使用前缀） */
        @JsonProperty("groupName")
        private String groupName;

        /** 超时时间（秒），最小15，最大300。在超时时间段内没有收到心跳，消费者将被删除 */
        @JsonProperty("timeout")
        private Integer timeout;

        /** 备注，长度不能超过100字符 */
        @JsonProperty("remark")
        private String remark;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public Integer getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public String getRemark() {
            return this.remark;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }
    }

    public static class CreateconsumerGroupResponse {
        /** 响应状态码。0：代表正常； -1：代表严重错误； -2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 消费组完整名称，使用此名称进行消费 */
        @JsonProperty("returnObj")
        private CreateconsumerGroupReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public CreateconsumerGroupReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CreateconsumerGroupReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class CreateconsumerGroupReturnObjResponse {}
}
