package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 创建ZOS-对象存储导入任务 */
public class CtltsCreateOssImportTaskApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsCreateOssImportTaskApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v1/import/createOssImportTask",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CreateOssImportTaskResponse send(
            Credential credential, CreateOssImportTaskRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreateOssImportTaskResponse.class);
    }

    public static class CreateOssImportTaskRequest {
        /** 资源池编码，可参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 日志单元ID，创建日志单元时会返回 */
        @JsonProperty("unitCode")
        private String unitCode;

        /** 日志项目ID，创建日志项目时会返回 */
        @JsonProperty("projectCode")
        private String projectCode;

        /** 编码格式, 仅支持传入UTF8和GBK */
        @JsonProperty("encode")
        private String encode;

        /** 导入任务名称, 名称仅支持字母、数字、下划线(_)和连字符(-),长度3-64且必须以字母和数字开头结尾 */
        @JsonProperty("name")
        private String name;

        /** 数据格式仅支持TEXT：单行全文；JSON：JSON格式；MULTI_TEXT：多行全文 */
        @JsonProperty("format")
        private String format;

        /** 对象存储bucket, 创建对象存储导入任务时必传 */
        @JsonProperty("bucket")
        private String bucket;

        /** 对象存储内文件压缩格式, 必传. none：不压缩；auto：自动检测；gzip：gzip压缩；lz4：lz4压缩；zstd：zstd压缩 */
        @JsonProperty("compressionCodec")
        private String compressionCodec;

        /** 文件路径前缀过滤, 非必传 */
        @JsonProperty("pathPrefix")
        private String pathPrefix;

        /** 文件路径正则过滤, 非必传 */
        @JsonProperty("pathPattern")
        private String pathPattern;

        /** 文件修改开始时间戳, 精确到毫秒 */
        @JsonProperty("startTime")
        private Long startTime;

        /** 文件修改截止时间戳,精确到毫秒 */
        @JsonProperty("endTime")
        private Long endTime;

        /** 定时任务检查新文件周期, 永不检查则不传参, 开启文件检查时必传 */
        @JsonProperty("customCheckCycle")
        private CreateOssImportTaskCustomCheckCycleRequest customCheckCycle;

        /** 用户自定义cron表达式, 自定义cron时传值, 非必传 */
        @JsonProperty("cron")
        private String cron;

        /** 正则切割模式，当切割模式为正则时需要 */
        @JsonProperty("regex")
        private CreateOssImportTaskRegexRequest regex;

        /** 用户自定义时间戳, 非必传 */
        @JsonProperty("customTimeInfoVo")
        private CreateOssImportTaskCustomTimeInfoVoRequest customTimeInfoVo;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getUnitCode() {
            return this.unitCode;
        }

        public void setUnitCode(String unitCode) {
            this.unitCode = unitCode;
        }

        public String getProjectCode() {
            return this.projectCode;
        }

        public void setProjectCode(String projectCode) {
            this.projectCode = projectCode;
        }

        public String getEncode() {
            return this.encode;
        }

        public void setEncode(String encode) {
            this.encode = encode;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public String getBucket() {
            return this.bucket;
        }

        public void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public String getCompressionCodec() {
            return this.compressionCodec;
        }

        public void setCompressionCodec(String compressionCodec) {
            this.compressionCodec = compressionCodec;
        }

        public String getPathPrefix() {
            return this.pathPrefix;
        }

        public void setPathPrefix(String pathPrefix) {
            this.pathPrefix = pathPrefix;
        }

        public String getPathPattern() {
            return this.pathPattern;
        }

        public void setPathPattern(String pathPattern) {
            this.pathPattern = pathPattern;
        }

        public Long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public Long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        public CreateOssImportTaskCustomCheckCycleRequest getCustomCheckCycle() {
            return this.customCheckCycle;
        }

        public void setCustomCheckCycle(
                CreateOssImportTaskCustomCheckCycleRequest customCheckCycle) {
            this.customCheckCycle = customCheckCycle;
        }

        public String getCron() {
            return this.cron;
        }

        public void setCron(String cron) {
            this.cron = cron;
        }

        public CreateOssImportTaskRegexRequest getRegex() {
            return this.regex;
        }

        public void setRegex(CreateOssImportTaskRegexRequest regex) {
            this.regex = regex;
        }

        public CreateOssImportTaskCustomTimeInfoVoRequest getCustomTimeInfoVo() {
            return this.customTimeInfoVo;
        }

        public void setCustomTimeInfoVo(
                CreateOssImportTaskCustomTimeInfoVoRequest customTimeInfoVo) {
            this.customTimeInfoVo = customTimeInfoVo;
        }
    }

    public static class CreateOssImportTaskCustomCheckCycleRequest {
        /** 定时任务周期单位, 支持传入minute：分钟；day：天； hour：小时；与时间间隔一起使用 */
        @JsonProperty("unit")
        private String unit;

        /** 时间间隔, 与任务周期单位一起使用 */
        @JsonProperty("interval")
        private Long interval;

        public String getUnit() {
            return this.unit;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        public Long getInterval() {
            return this.interval;
        }

        public void setInterval(Long interval) {
            this.interval = interval;
        }
    }

    public static class CreateOssImportTaskRegexRequest {
        /** 提取正则, 单行正则或多行正则提取模式下必填,例如：(\d+-\d+-\d+\s\S+)\s+\[([^]]+)]\s+(\w+)\s+(\S+)\s+(.*) */
        @JsonProperty("regexStr")
        private String regexStr;

        /** 首行正则表达式, 多行全文提取模式下必填，例如：\d+-\d+-\d+\s\d+:\d+:\d+\.\d+\s.* */
        @JsonProperty("firstLinePattern")
        private String firstLinePattern;

        /** 日志提取内容 */
        @JsonProperty("logContent")
        private List<CreateOssImportTaskRegexLogContentRequest> logContent;

        public String getRegexStr() {
            return this.regexStr;
        }

        public void setRegexStr(String regexStr) {
            this.regexStr = regexStr;
        }

        public String getFirstLinePattern() {
            return this.firstLinePattern;
        }

        public void setFirstLinePattern(String firstLinePattern) {
            this.firstLinePattern = firstLinePattern;
        }

        public List<CreateOssImportTaskRegexLogContentRequest> getLogContent() {
            return this.logContent;
        }

        public void setLogContent(List<CreateOssImportTaskRegexLogContentRequest> logContent) {
            this.logContent = logContent;
        }
    }

    public static class CreateOssImportTaskCustomTimeInfoVoRequest {
        /** 自定义时间戳字段名 */
        @JsonProperty("key")
        private String key;

        /** 自定义时间戳字段值 */
        @JsonProperty("value")
        private String value;

        /** 提取时间格式 */
        @JsonProperty("timeFormat")
        private String timeFormat;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getTimeFormat() {
            return this.timeFormat;
        }

        public void setTimeFormat(String timeFormat) {
            this.timeFormat = timeFormat;
        }
    }

    public static class CreateOssImportTaskRegexLogContentRequest {
        /** 提取字段 */
        @JsonProperty("key")
        private String key;

        /** 数据类型。text：字符串；double：数字 */
        @JsonProperty("type")
        private String type;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    public static class CreateOssImportTaskResponse {
        /** 响应状态码。0：代表正常； -1：代表严重错误； -2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 调用错误时返回的错误编码 */
        @JsonProperty("error")
        private String error;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private CreateOssImportTaskReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public CreateOssImportTaskReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CreateOssImportTaskReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class CreateOssImportTaskReturnObjResponse {
        /** 对象存储导入任务 */
        @JsonProperty("taskCode")
        private String taskCode;

        public String getTaskCode() {
            return this.taskCode;
        }

        public void setTaskCode(String taskCode) {
            this.taskCode = taskCode;
        }
    }
}
