package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 创建分布式消费服务Kafka导入任务 */
public class CtltsCreateKafkaImportTaskApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsCreateKafkaImportTaskApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v1/import/createKafkaImportTask",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CreateKafkaImportTaskResponse send(
            Credential credential, CreateKafkaImportTaskRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreateKafkaImportTaskResponse.class);
    }

    public static class CreateKafkaImportTaskRequest {
        /** 资源池编码，可参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 日志单元ID，创建日志单元会返回 */
        @JsonProperty("unitCode")
        private String unitCode;

        /** 日志项目ID，创建日志项目会返回 */
        @JsonProperty("projectCode")
        private String projectCode;

        /** 编码格式, 仅支持传入UTF8和GBK */
        @JsonProperty("encode")
        private String encode;

        /** 导入任务名称, 名称仅支持字母、数字、下划线(_)和连字符(-),长度3-64且必须以字母和数字开头结尾 */
        @JsonProperty("name")
        private String name;

        /** 用户自定义消费组名称 */
        @JsonProperty("consumerGroup")
        private String consumerGroup;

        /** 数据格式，仅支持TEXT：单行全文； JSON：JSON格式 */
        @JsonProperty("format")
        private String format;

        /** topic列表 */
        @JsonProperty("topics")
        private List<String> topics;

        /** 消费组起始位置, newest：从最早的位置开始消费；oldest：从最新的位置开始消费 */
        @JsonProperty("offset")
        private String offset;

        /** kafka实例信息 */
        @JsonProperty("kafkaIns")
        private CreateKafkaImportTaskKafkaInsRequest kafkaIns;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getUnitCode() {
            return this.unitCode;
        }

        public void setUnitCode(String unitCode) {
            this.unitCode = unitCode;
        }

        public String getProjectCode() {
            return this.projectCode;
        }

        public void setProjectCode(String projectCode) {
            this.projectCode = projectCode;
        }

        public String getEncode() {
            return this.encode;
        }

        public void setEncode(String encode) {
            this.encode = encode;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getConsumerGroup() {
            return this.consumerGroup;
        }

        public void setConsumerGroup(String consumerGroup) {
            this.consumerGroup = consumerGroup;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public List<String> getTopics() {
            return this.topics;
        }

        public void setTopics(List<String> topics) {
            this.topics = topics;
        }

        public String getOffset() {
            return this.offset;
        }

        public void setOffset(String offset) {
            this.offset = offset;
        }

        public CreateKafkaImportTaskKafkaInsRequest getKafkaIns() {
            return this.kafkaIns;
        }

        public void setKafkaIns(CreateKafkaImportTaskKafkaInsRequest kafkaIns) {
            this.kafkaIns = kafkaIns;
        }
    }

    public static class CreateKafkaImportTaskKafkaInsRequest {
        /** kafka实例ID */
        @JsonProperty("instanceId")
        private String instanceId;

        /** kafka实例所在vpc */
        @JsonProperty("vpcId")
        private String vpcId;

        /** kafka实例所在subnet */
        @JsonProperty("subnetId")
        private String subnetId;

        /** kafka实例名称 */
        @JsonProperty("insName")
        private String insName;

        public String getInstanceId() {
            return this.instanceId;
        }

        public void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public String getVpcId() {
            return this.vpcId;
        }

        public void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public String getSubnetId() {
            return this.subnetId;
        }

        public void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public String getInsName() {
            return this.insName;
        }

        public void setInsName(String insName) {
            this.insName = insName;
        }
    }

    public static class CreateKafkaImportTaskResponse {
        /** 响应状态码。0：代表正常； -1：代表严重错误； -2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 调用错误时返回的错误编码 */
        @JsonProperty("error")
        private String error;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 消息内容 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private CreateKafkaImportTaskReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public CreateKafkaImportTaskReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CreateKafkaImportTaskReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class CreateKafkaImportTaskReturnObjResponse {
        /** Kafka导入任务编码 */
        @JsonProperty("taskCode")
        private String taskCode;

        public String getTaskCode() {
            return this.taskCode;
        }

        public void setTaskCode(String taskCode) {
            this.taskCode = taskCode;
        }
    }
}
